#ifndef _MACRO_MG82F6P32_H
#define _MACRO_MG82F6P32_H

#define SFR_SetPage(x)		SFRPI=x

/*
//*************************************************************************************
//*  INTERRUPT 中断
//*
//*************************************************************************************
*/
//中断向量
#define INT_VECTOR_INT0		0
#define INT_VECTOR_T0		1
#define INT_VECTOR_INT1		2
#define INT_VECTOR_T1		3
#define INT_VECTOR_UART0	4
#define INT_VECTOR_T2		5
#define INT_VECTOR_INT2		6
#define INT_VECTOR_SPI		7
#define INT_VECTOR_ADC		8
#define INT_VECTOR_PTM0		9
#define INT_VECTOR_SF		10
#define INT_VECTOR_KB		11
#define INT_VECTOR_TWI0		12
#define INT_VECTOR_AC0		13
#define INT_VECTOR_UART1	14
#define INT_VECTOR_INT3		15
#define INT_VECTOR_T3		16
#define INT_VECTOR_AC1		17
#define INT_VECTOR_DMA		18
#define	INT_VECTOR_PCA1		19
#define	INT_VECTOR_TWI1		23

//中断使能/禁止
#define INT_EnAll()			EA=1		// 使能全局中断
#define INT_DisAll()		EA=0		// 禁止全局中断
#define INT_EnINT0()		EX0=1
#define INT_DisINT0()		EX0=0
#define INT_EnTIMER0()		ET0=1
#define INT_DisTIMER0()		ET0=0
#define INT_EnINT1()		EX1=1
#define INT_DisINT1()		EX1=0
#define INT_EnTIMER1()		ET1=1
#define INT_DisTIMER1()		ET1=0
#define INT_EnUART0()		ES0=1
#define INT_DisUART0()		ES0=0
#define INT_EnTIMER2()		ET2=1
#define INT_EnTIMER2L()		TCLK_TL2IE=1
#define INT_DisTIMER2L()	TCLK_TL2IE=0
#define INT_DisTIMER2()		ET2=0
#define INT_EnINT2()		EX2=1
#define INT_DisINT2()		EX2=0
#define INT_EnSPI()			EIE1=EIE1|ESPI
#define INT_DisSPI()		EIE1=EIE1&(~ESPI)
#define INT_EnADC()			EIE1=EIE1|EADC
#define INT_DisADC()		EIE1=EIE1&(~EADC)
#define INT_EnPTM0()		EIE1=EIE1|EPCA
#define INT_DisPTM0()		EIE1=EIE1&(~EPCA)
#define INT_EnSF()			EIE1=EIE1|ESF
#define INT_DisSF()			EIE1=EIE1&(~ESF)
#define INT_EnKBI()			EIE1=EIE1|EKB
#define INT_DisKBI()		EIE1=EIE1&(~EKB)
#define INT_EnTWI0()		EIE1=EIE1|ETWI0
#define INT_DisTWI0()		EIE1=EIE1&(~ETWI0)
#define INT_EnAC0()			EIE1=EIE1|EAC0
#define	INT_DisAC0()		EIE1=EIE1&(~EAC0)
#define INT_EnUART1()		EIE1=EIE1|ES1
#define INT_DisUART1()		EIE1=EIE1&(~ES1)
#define INT_EnINT3()		EX3=1
#define INT_DisINT3()		EX3=0
#define INT_EnTIMER3()		EIE2=EIE2|ET3
#define INT_DisTIMER3()		EIE2=EIE2&(~ET3)
#define INT_EnTIMER3L()		SFRPI=T3CON_Page;TL3IE=1;SFRPI=0
#define INT_DisTIMER3L()	SFRPI=T3CON_Page;TL3IE=0;SFRPI=0
#define INT_EnAC1_OPA0_OPA1()			EIE2=EIE2|EAC1
#define	INT_DisAC1_OPA0_OPA1()			EIE2=EIE2&(~EAC1)
#define INT_EnDMA()			EDMA=1
#define INT_DisDMA()		EDMA=0

#define INT_EnPCA1()		EIE2=EIE2|EPCA1
#define INT_DisPCA1()		EIE2=EIE2&(~EPCA1)
#define INT_EnTWI1()		EIE2=EIE2|ETWI1
#define INT_DisTWI1()		EIE2=EIE2&(~ETWI1)

#define INT_EnSF_WDT()		SFIE=SFIE|WDTFIE
#define INT_DisSF_WDT()		SFIE=SFIE&(~WDTFIE)
#define INT_EnSF_BOD0()		SFIE=SFIE|BOF0IE
#define INT_DisSF_BOD0()	SFIE=SFIE&(~BOF0IE)
#define INT_EnSF_BOD1()		SFIE=SFIE|BOF1IE
#define INT_DisSF_BOD1()	SFIE=SFIE&(~BOF1IE)
#define INT_EnSF_SP()		SFIE=SFIE|SPWIE
#define INT_DisSF_SP()		SFIE=SFIE&(~SPWIE)
#define INT_EnSF_RTC()		SFIE=SFIE|RTCFIE
#define INT_DisSF_RTC()		SFIE=SFIE&(~RTCFIE)
#define INT_EnSF_MCD()		SFIE=SFIE|MCDFIE
#define INT_DisSF_MCD()		SFIE=SFIE&(~MCDFIE)
#define	INT_EnSF_UART0()	S0CFG=S0CFG|UTIE
#define	INT_DisSF_UART0()	S0CFG=S0CFG&(~UTIE)
#define INT_EnSF_SID()		SFIE=SFIE|SIDFIE
#define INT_DisSF_SID()		SFIE=SFIE&(~SIDFIE)

// 中断优先级
#define IP_INT0		BIT0
#define IP_T0		BIT1
#define IP_INT1		BIT2
#define IP_T1		BIT3
#define IP_UART0	BIT4
#define IP_T2		BIT5
#define IP_INT2		BIT6
#define IP_INT3		BIT7
#define INT_SetIPHighest(x)			IP0H=IP0H|x;IP0L=IP0L|x
#define INT_SetIPHigh(x)			IP0H=IP0H|x;IP0L=IP0L&(~x)
#define INT_SetIPLow(x)				IP0H=IP0H&(~x);IP0L=IP0L|x
#define INT_SetIPLowest(x)			IP0H=IP0H&(~x);IP0L=IP0L&(~x)

#define IPX_SPI		BIT0
#define IPX_ADC		BIT1
#define IPX_PCA		BIT2
#define IPX_SF		BIT3
#define IPX_UART1	BIT4
#define IPX_KB		BIT5
#define IPX_TWI0	BIT6
#define IPX_AC0		BIT7
#define INT_SetIPXHighest(x)		EIP1H=EIP1H|x;EIP1L=EIP1L|x
#define INT_SetIPXHigh(x)			EIP1H=EIP1H|x;EIP1L=EIP1L&(~x)
#define INT_SetIPXLow(x)			EIP1H=EIP1H&(~x);EIP1L=EIP1L|x
#define INT_SetIPXLowest(x)			EIP1H=EIP1H&(~x);EIP1L=EIP1L&(~x)

#define IPX2_TIMER3		BIT0
#define IPX2_AC1_OPA0_OPA1		BIT1
#define IPX2_TWI1		BIT6
#define INT_SetIPX2Highest(x)		EIP2H=EIP2H|x;EIP2L=EIP2L|x
#define INT_SetIPX2High(x)			EIP2H=EIP2H|x;EIP2L=EIP2L&(~x)
#define INT_SetIPX2Low(x)			EIP2H=EIP2H&(~x);EIP2L=EIP2L|x
#define INT_SetIPX2Lowest(x)		EIP2H=EIP2H&(~x);EIP2L=EIP2L&(~x)

#define INT_SetDMAIPHighest(x)		SFRPI=DMACG0_Page;DMACG0=DMACG0|(PDMAH|PDMAL);SFRPI=0
#define INT_SetDMAIPHigh(x)			SFRPI=DMACG0_Page;DMACG0=(DMACG0&(~(PDMAH|PDMAL)))|(PDMAH);SFRPI=0
#define INT_SetDMAIPLow(x)			SFRPI=DMACG0_Page;DMACG0=(DMACG0&(~(PDMAH|PDMAL)))|(PDMAL);SFRPI=0
#define INT_SetDMAIPLowest(x)		SFRPI=DMACG0_Page;DMACG0=DMACG0&(~(PDMAH|PDMAL));SFRPI=0

// 外部中断 选择中断引脚
#define INT_SetINT0P32()			XICFG=XICFG&(~(INT0IS0|INT0IS1));SFRPI =XICFG1_Page;XICFG1=XICFG1&(~INT0IS2);SFRPI=0
#define INT_SetINT0P30()			XICFG=(XICFG&(~INT0IS1))|INT0IS0;SFRPI =XICFG1_Page;XICFG1=XICFG1&(~INT0IS2);SFRPI=0
#define INT_SetINT0P34()			XICFG=(XICFG&(~INT0IS0))|INT0IS1;SFRPI =XICFG1_Page;XICFG1=XICFG1&(~INT0IS2);SFRPI=0
#define INT_SetINT0P40()			XICFG=XICFG|(INT0IS0|INT0IS1);SFRPI =XICFG1_Page;XICFG1=XICFG1&(~INT0IS2);SFRPI=0
#define INT_SetINT0P10()			XICFG=XICFG&(~(INT0IS0|INT0IS1));SFRPI =XICFG1_Page;XICFG1=XICFG1|INT0IS2;SFRPI=0
#define INT_SetINT0P14()			XICFG=(XICFG&(~INT0IS1))|INT0IS0;SFRPI =XICFG1_Page;XICFG1=XICFG1|INT0IS2;SFRPI=0
#define INT_SetINT0P17()			XICFG=(XICFG&(~INT0IS0))|INT0IS1;SFRPI =XICFG1_Page;XICFG1=XICFG1|INT0IS2;SFRPI=0
#define INT_SetINT0P05()			XICFG=XICFG|(INT0IS0|INT0IS1);SFRPI =XICFG1_Page;XICFG1=XICFG1|INT0IS2;SFRPI=0

#define INT_SetINT1P33()			XICFG=XICFG&(~(INT1IS0|INT1IS1));SFRPI =XICFG1_Page;XICFG1=XICFG1&(~INT1IS2);SFRPI=0
#define INT_SetINT1P31()			XICFG=(XICFG&(~INT1IS1))|INT1IS0;SFRPI =XICFG1_Page;XICFG1=XICFG1&(~INT1IS2);SFRPI=0
#define INT_SetINT1P35()			XICFG=(XICFG&(~INT1IS0))|INT1IS1;SFRPI =XICFG1_Page;XICFG1=XICFG1&(~INT1IS2);SFRPI=0
#define INT_SetINT1P41()			XICFG=XICFG|(INT1IS0|INT1IS1);SFRPI =XICFG1_Page;XICFG1=XICFG1&(~INT1IS2);SFRPI=0
#define INT_SetINT1P45()			XICFG=XICFG&(~(INT1IS0|INT1IS1));SFRPI =XICFG1_Page;XICFG1=XICFG1|INT1IS2;SFRPI=0
#define INT_SetINT1P15()			XICFG=(XICFG&(~INT1IS1))|INT1IS0;SFRPI =XICFG1_Page;XICFG1=XICFG1|INT1IS2;SFRPI=0
#define INT_SetINT1P10()			XICFG=(XICFG&(~INT1IS0))|INT1IS1;SFRPI =XICFG1_Page;XICFG1=XICFG1|INT1IS2;SFRPI=0
#define INT_SetINT1P07()			XICFG=XICFG|(INT1IS0|INT1IS1);SFRPI =XICFG1_Page;XICFG1=XICFG1|INT1IS2;SFRPI=0

#define INT_SetINT2P44()			SFRPI=XICFG1_Page;XICFG1=XICFG1&(~(INT2IS0|INT2IS1));SFRPI=0
#define INT_SetINT2P30()			SFRPI=XICFG1_Page;XICFG1=(XICFG1&(~INT2IS1))|INT2IS0;SFRPI=0
#define INT_SetINT2P11()			SFRPI=XICFG1_Page;XICFG1=(XICFG1&(~INT2IS0))|INT2IS1;SFRPI=0
#define INT_SetINT2P16()			SFRPI=XICFG1_Page;XICFG1=XICFG1|(INT2IS0|INT2IS1);SFRPI=0
#define INT_SetINT2P14()			SFRPI=XICFG1_Page;XICFG1=XICFG1&(~(INT2IS0|INT2IS1));SFRPI=XICFG2_Page;XICFG2=XICFG2|INT2IS2;SFRPI=0
#define INT_SetINT2P60()			SFRPI=XICFG1_Page;XICFG1=(XICFG1&(~INT2IS1))|INT2IS0;SFRPI=XICFG2_Page;XICFG2=XICFG2|INT2IS2;SFRPI=0
#define INT_SetINT2P01()			SFRPI=XICFG1_Page;XICFG1=(XICFG1&(~INT2IS0))|INT2IS1;SFRPI=XICFG2_Page;XICFG2=XICFG2|INT2IS2;SFRPI=0
#define INT_SetINT2P61()			SFRPI=XICFG1_Page;XICFG1=XICFG1|(INT2IS0|INT2IS1);SFRPI=XICFG2_Page;XICFG2=XICFG2|INT2IS2;SFRPI=0

#define INT_SetINT3P45()			SFRPI=XICFG2_Page;XICFG2=XICFG2&(~(INT3IS0|INT3IS1|INT3IS2));SFRPI=0
#define INT_SetINT3P22()			SFRPI=XICFG2_Page;XICFG2=(XICFG2&(~(INT3IS0|INT3IS1|INT3IS2)))|(INT3IS0);SFRPI=0
#define INT_SetINT3P15()			SFRPI=XICFG2_Page;XICFG2=(XICFG2&(~(INT3IS0|INT3IS1|INT3IS2)))|(INT3IS1);SFRPI=0
#define INT_SetINT3P16()			SFRPI=XICFG2_Page;XICFG2=(XICFG2&(~(INT3IS0|INT3IS1|INT3IS2)))|(INT3IS0|INT3IS1);SFRPI=0
#define INT_SetINT3P02()			SFRPI=XICFG2_Page;XICFG2=(XICFG2&(~(INT3IS0|INT3IS1|INT3IS2)))|(INT3IS2);SFRPI=0
#define INT_SetINT3P61()			SFRPI=XICFG2_Page;XICFG2=(XICFG2&(~(INT3IS0|INT3IS1|INT3IS2)))|(INT3IS0|INT3IS2);SFRPI=0
#define INT_SetINT3P12()			SFRPI=XICFG2_Page;XICFG2=(XICFG2&(~(INT3IS0|INT3IS1|INT3IS2)))|(INT3IS1|INT3IS2);SFRPI=0
#define INT_SetINT3P60()			SFRPI=XICFG2_Page;XICFG2=(XICFG2&(~(INT3IS0|INT3IS1|INT3IS2)))|(INT3IS0|INT3IS1|INT3IS2);SFRPI=0

// 外部中断 设置检测电平/边沿
#define INT_SetINT0_DetectLevel()		IT0=0
#define	INT_SetINT0_DetectEdge()		IT0=1

#define INT_SetINT1_DetectLevel()		IT1=0
#define	INT_SetINT1_DetectEdge()		IT1=1

#define INT_SetINT2_DetectLevel()		IT2=0
#define	INT_SetINT2_DetectEdge()		IT2=1

#define INT_SetINT3_DetectLevel()		IT3=0
#define	INT_SetINT3_DetectEdge()		IT3=1

// 外部中断 详细判断是哪一沿/电平
#define INT_SetINT0_DetectLowFalling()	AUXR0=AUXR0&(~INT0H)
#define INT_SetINT0_DetectHighRising()	AUXR0=AUXR0|INT0H

#define INT_SetINT1_DetectLowFalling()	AUXR0=AUXR0&(~INT1H)
#define INT_SetINT1_DetectHighRising()	AUXR0=AUXR0|INT1H

#define INT_SetINT2_DetectLowFalling()	INT2H=0
#define INT_SetINT2_DetectHighRising()	INT2H=1

#define INT_SetINT3_DetectLowFalling()	INT3H=0
#define INT_SetINT3_DetectHighRising()	INT3H=1

#define INT_SetINT0_DetectHighLevel()		IT0=0;AUXR0=AUXR0|INT0H
#define INT_SetINT0_DetectLowLevel()		IT0=0;AUXR0=AUXR0&(~INT0H)
#define	INT_SetINT0_DetectFallingEdge()		IT0=1;AUXR0=AUXR0&(~INT0H)
#define	INT_SetINT0_DetectRisingEdge()		IT0=1;AUXR0=AUXR0|INT0H

#define INT_SetINT1_DetectHighLevel()		IT1=0;AUXR0=AUXR0|INT1H
#define INT_SetINT1_DetectLowLevel()		IT1=0;AUXR0=AUXR0&(~INT1H)
#define	INT_SetINT1_DetectFallingEdge()		IT1=1;AUXR0=AUXR0&(~INT1H)
#define	INT_SetINT1_DetectRisingEdge()		IT1=1;AUXR0=AUXR0|INT1H

#define INT_SetINT2_DetectHighLevel()		IT2=0;INT2H=1
#define INT_SetINT2_DetectLowLevel()		IT2=0;INT2H=0
#define	INT_SetINT2_DetectFallingEdge()		IT2=1;INT2H=0
#define	INT_SetINT2_DetectRisingEdge()		IT2=1;INT2H=1

#define INT_SetINT3_DetectHighLevel()		IT3=0;INT3H=1
#define INT_SetINT3_DetectLowLevel()		IT3=0;INT3H=0
#define	INT_SetINT3_DetectFallingEdge()		IT3=1;INT3H=0
#define	INT_SetINT3_DetectRisingEdge()		IT3=1;INT3H=1

// 外部中断 设置滤波
#define INT_SetINT0Filter_Disable()				XICFG=XICFG&(~X0FLT);SFRPI=XICFG1_Page;XICFG1=XICFG1&(~X0FLT1);SFRPI=0
#define INT_SetINT0Filter_Sysclk_x3()			XICFG=XICFG|X0FLT;SFRPI=XICFG1_Page;XICFG1=XICFG1&(~X0FLT1);SFRPI=0
#define INT_SetINT0Filter_SysclkDiv6_x3()		XICFG=XICFG&(~X0FLT);SFRPI=XICFG1_Page;XICFG1=XICFG1|X0FLT1;SFRPI=0
#define INT_SetINT0Filter_S0TOF_x3()			XICFG=XICFG|X0FLT;SFRPI=XICFG1_Page;XICFG1=XICFG1|X0FLT1;SFRPI=0

#define INT_SetINT1Filter_Disable()				XICFG=XICFG&(~X1FLT);SFRPI=XICFG1_Page;XICFG1=XICFG1&(~X1FLT1);SFRPI=0
#define INT_SetINT1Filter_Sysclk_x3()			XICFG=XICFG|X1FLT;SFRPI=XICFG1_Page;XICFG1=XICFG1&(~X1FLT1);SFRPI=0
#define INT_SetINT1Filter_SysclkDiv6_x3()		XICFG=XICFG&(~X1FLT);SFRPI=XICFG1_Page;XICFG1=XICFG1|X1FLT1;SFRPI=0
#define INT_SetINT1Filter_S0TOF_x3()			XICFG=XICFG|X1FLT;SFRPI=XICFG1_Page;XICFG1=XICFG1|X1FLT1;SFRPI=0

#define INT_SetINT2Filter_Disable()				XICFG=XICFG&(~X2FLT);SFRPI=XICFG1_Page;XICFG1=XICFG1&(~X2FLT1);SFRPI=0
#define INT_SetINT2Filter_Sysclk_x3()			XICFG=XICFG|X2FLT;SFRPI=XICFG1_Page;XICFG1=XICFG1&(~X2FLT1);SFRPI=0
#define INT_SetINT2Filter_SysclkDiv6_x3()		XICFG=XICFG&(~X2FLT);SFRPI=XICFG1_Page;XICFG1=XICFG1|X2FLT1;SFRPI=0
#define INT_SetINT2Filter_S0TOF_x3()			XICFG=XICFG|X2FLT;SFRPI=XICFG1_Page;XICFG1=XICFG1|X2FLT1;SFRPI=0

#define INT_SetINT3Filter_Disable()				XICFG=XICFG&(~X3FLT);SFRPI=XICFG1_Page;XICFG1=XICFG1&(~X3FLT1);SFRPI=0
#define INT_SetINT3Filter_Sysclk_x3()			XICFG=XICFG|X3FLT;SFRPI=XICFG1_Page;XICFG1=XICFG1&(~X3FLT1);SFRPI=0
#define INT_SetINT3Filter_SysclkDiv6_x3()		XICFG=XICFG&(~X3FLT);SFRPI=XICFG1_Page;XICFG1=XICFG1|X3FLT1;SFRPI=0
#define INT_SetINT3Filter_S0TOF_x3()			XICFG=XICFG|X3FLT;SFRPI=XICFG1_Page;XICFG1=XICFG1|X3FLT1;SFRPI=0

/*
*************************************************************************************
*/



/*
//*************************************************************************************
//*  IAP
//*
//*************************************************************************************
*/
//IAP 命令
#define ISP_STANBY		0
#define ISP_READ		1 	  //读
#define ISP_WRITE 	    2 	  //写
#define ISP_ERASE 	    3 	  //擦除
#define ISP_WRITE_P     4     //写P页寄存器
#define ISP_READ_P     	5     //读P页寄存器
#define ISP_AUTO_FLASH_CRC	0x80	// 自动计算FLASH CRC
#define ISP_READ_BYTE_INC	0x81	// FLASH读字节,地址递增
#define ISP_WRITE_BYTE_INC	0x82	// FLASH写字节,地址递增

/*
*************************************************************************************
*/


/*
//*************************************************************************************
//*  CLOCK
//*
//*************************************************************************************
*/
// CLOCK IHRCO 是12MHz/11.0592MHz
#define IHRCO_12MHz					0
#define IHRCO_110592MHz				0x80
#define CLK_SelIHRCO12MHz()					CKCON0=CKCON0&(~AFS)
#define CLK_SelIHRCO110592MHz()				CKCON0=CKCON0|(AFS)

// CLOCK 设置CPUCLK
#define CPUCLK_SYSCLK_DIV_1			0
#define CPUCLK_SYSCLK_DIV_2			0x08
#define CLK_SetCpuclkUseSysclk()			CKCON0=CKCON0&(~CCKS)
#define CLK_SetCpuclkUseSysclkDiv2()		CKCON0=CKCON0|(CCKS)

// CLOCK 设置SYSCLK
#define SYSCLK_MCKDO_DIV_1			0
#define SYSCLK_MCKDO_DIV_2			1
#define SYSCLK_MCKDO_DIV_4			2
#define SYSCLK_MCKDO_DIV_8			3
#define SYSCLK_MCKDO_DIV_16			4
#define SYSCLK_MCKDO_DIV_32			5
#define SYSCLK_MCKDO_DIV_64			6
#define SYSCLK_MCKDO_DIV_128		7
#define CLK_SetSysclk(x)					CKCON0=(CKCON0&(~0x07))|x

// CLOCK 开启/关闭CKM
#define DISABLE_CKM					0
#define ENABLE_CKM					0x40
#define CLK_DisCKM()						CKCON0=CKCON0&(~ENCKM)
#define CLK_EnCKM()							CKCON0=CKCON0|(ENCKM)

// CLOCK 选择CKM输入源
#define CKM_OSCIN_DIV_1				0x00	// OSCin=5~7MHz
#define CKM_OSCIN_DIV_2				0x10	// OSCin=10~14MHz
#define CKM_OSCIN_DIV_4				0x20	// OSCin=20~28MHz
#define CKM_OSCIN_DIV_6				0x30	// OSCin=30~42MHz
#define CLK_SetCKMOSCin(x)					CKCON0=(CKCON0&(~0x30))|x

// CLOCK 设置CKCON0
#define CLK_SetCKCON0(x)					CKCON0=x

// CLOCK 设置CKCON2

#define DISABLE_IHRCO				0x00
#define ENABLE_IHRCO				0x10

#define ENABLE_XTAL					0x20
#define DISABLE_XTAL				0x00

#define	GAIN_FOR_32K				0x00	// for 32.768KHz
#define GAIN_FOR_2M_25M				0x40	// for 2~25MHz
#define	GAIN_FOR_LOW				0x80    // for 32.768KHz

#define MCK_OSCin					0x00
#define MCK_CKMI_X4					0x04
#define MCK_CKMI_X533				0x08
#define MCK_CKMI_X8					0x0C

#define OSCIn_IHRCO					0x00
#define OSCIn_XTAL					0x01
#define OSCIn_ILRCO					0x02
#define OSCIn_ECKI_P60				0x03

#define CLK_SetCKCON2(x)			ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON2_P;IFMT=ISP_WRITE_P;IFD=x;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0

// CLOCK 设置CKCON3
#define WDTCS_ILRCO					0x00
#define WDTCS_XTAL2_ECKI			0x40
#define WDTCS_SYSCLK_DIV_12			0x80
#define WDTCS_S0TOF					0xC0

#define FWKP_NORMAL_120uS			0x00
#define FWKP_FAST_30uS				0x20

#define MCKDO_MCK_DIV_1				0x00
#define MCKDO_MCK_DIV_2				0x04
#define MCKDO_MCK_DIV_4				0x08
#define MCKDO_MCK_DIV_8				0x0C

#define CLK_SetCKCON3(x)			ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON3_P;IFMT=ISP_WRITE_P;IFD=x;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0

// CLOCK 设置CPU超高速运行(>25MHz)
#define CLK_SetCpuCLK_HighSpeed()	ISPCR=0x80;IFADRH=0x0;IFADRL=DCON0_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=IFD|(HSE_P|HSE1_P);IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0

// CLOCK 设置IAP时基
#define CLK_SetIAPTimeBase(x)		CKCON1=x-1

// CLOCK 设置P60输出CLK
#define CLK_P60OC_P60()			SFRPI=AUXR10_Page;AUXR10=AUXR10&(~(P60OC0|P60OC1));SFRPI=0
#define CLK_P60OC_MCK()			SFRPI=AUXR10_Page;AUXR10=(AUXR10&(~(P60OC0|P60OC1)))|(P60OC0);SFRPI=0
#define CLK_P60OC_MCKDiv2()		SFRPI=AUXR10_Page;AUXR10=(AUXR10&(~(P60OC0|P60OC1)))|(P60OC1);SFRPI=0
#define CLK_P60OC_MCKDiv4()		SFRPI=AUXR10_Page;AUXR10=AUXR10|((P60OC0|P60OC1));SFRPI=0

// CLOCK 设置P60输出CLK快速驱动
#define CLK_P60EnFastDrive()	SFRPI=AUXR10_Page;AUXR10=AUXR10|P60FD;SFRPI=0
#define	CLK_P60DisFastDrive()	SFRPI=AUXR10_Page;AUXR10=AUXR10&~P60FD;SFRPI=0
/*
*************************************************************************************
*/

/*
//*************************************************************************************
//*  TIMER0 & TIMER1
//*
//*************************************************************************************
*/
// 使能或关闭TIMER
#define TM_DisableT0()			TR0=0
#define TM_EnableT0()			TR0=1
#define TM_DisableT1()			TR1=0
#define TM_EnableT1()			TR1=1

// 选择TIMER工作模式
#define TM_SetT0Mode_0_8BIT_PWM()				TMOD=(TMOD&(~(T0M0|T0M1)))
#define TM_SetT0Mode_1_16BIT_TIMER()			TMOD=(TMOD&(~(T0M0|T0M1)))|(T0M0)
#define TM_SetT0Mode_2_8BIT_AUTORELOAD()		TMOD=(TMOD&(~(T0M0|T0M1)))|(T0M1)
#define TM_SetT0Mode_3_TWO_8BIT()				TMOD=(TMOD|(T0M0|T0M1))


#define TM_SetT0Gate_Disable()					TMOD=TMOD&(~T0GATE);SFRPI=6;AUXR9=AUXR9&(~T0G1);SFRPI=0
#define TM_SetT0Gate_INT0()						TMOD=TMOD|T0GATE;SFRPI=6;AUXR9=AUXR9&(~T0G1);SFRPI=0
#define TM_SetT0Gate_TF2()						TMOD=TMOD&(~T0GATE);SFRPI=6;AUXR9=AUXR9|(T0G1);SFRPI=0
#define TM_SetT0Gate_KBI()						TMOD=TMOD|T0GATE;SFRPI=6;AUXR9=AUXR9|(T0G1);SFRPI=0

#define TM_SetT1Mode_0_8BIT_PWM()				TMOD=(TMOD&(~(T1M0|T1M1)))
#define TM_SetT1Mode_1_16BIT_TIMER()			TMOD=(TMOD&(~(T1M0|T1M1)))|(T1M0)
#define TM_SetT1Mode_2_8BIT_AUTORELOAD()		TMOD=(TMOD&(~(T1M0|T1M1)))|(T1M1)
#define TM_SetT1Mode_3_Disable()				TMOD=(TMOD|(T1M0|T1M1))

#define TM_SetT1Gate_Disable()					TMOD=TMOD&(~T1GATE);SFRPI=6;AUXR9=AUXR9&(~T1G1);SFRPI=0
#define TM_SetT1Gate_INT1()						TMOD=TMOD|T1GATE;SFRPI=6;AUXR9=AUXR9&(~T1G1);SFRPI=0
#define TM_SetT1Gate_TF3()						TMOD=TMOD&(~T1GATE);SFRPI=6;AUXR9=AUXR9|(T1G1);SFRPI=0
#define TM_SetT1Gate_TI1()						TMOD=TMOD|T1GATE;SFRPI=6;AUXR9=AUXR9|(T1G1);SFRPI=0

// 选择TIMER时钟源
#define TM_SetT0Clock_SYSCLKDiv12()				AUXR3=(AUXR3&(~T0XL));AUXR2=(AUXR2&(~T0X12));TMOD=(TMOD&(~T0C_T))
#define TM_SetT0Clock_T0Port()					AUXR3=(AUXR3&(~T0XL));AUXR2=(AUXR2&(~T0X12));TMOD=(TMOD|(T0C_T))
#define TM_SetT0Clock_SYSCLK()					AUXR3=(AUXR3&(~T0XL));AUXR2=(AUXR2|(T0X12));TMOD=(TMOD&(~T0C_T))
#define TM_SetT0Clock_ILRCO()					AUXR3=(AUXR3&(~T0XL));AUXR2=(AUXR2|(T0X12));TMOD=(TMOD|(T0C_T))
#define TM_SetT0Clock_SYSCLKDiv48()				AUXR3=(AUXR3|(T0XL));AUXR2=(AUXR2&(~T0X12));TMOD=(TMOD&(~T0C_T))
#define TM_SetT0Clock_WDTPS()					AUXR3=(AUXR3|(T0XL));AUXR2=(AUXR2&(~T0X12));TMOD=(TMOD|(T0C_T))
#define TM_SetT0Clock_SYSCLKDiv192()			AUXR3=(AUXR3|(T0XL));AUXR2=(AUXR2|(T0X12));TMOD=(TMOD&(~T0C_T))
#define TM_SetT0Clock_T1OF()					AUXR3=(AUXR3|(T0XL));AUXR2=(AUXR2|(T0X12));TMOD=(TMOD|(T0C_T))

#define TM_SetT1Clock_SYSCLKDiv12()				AUXR2=(AUXR2&(~T1X12));TMOD=(TMOD&(~T1C_T))
#define TM_SetT1Clock_T1Port()					AUXR2=(AUXR2&(~T1X12));TMOD=(TMOD|(T1C_T))
#define TM_SetT1Clock_SYSCLK()					AUXR2=(AUXR2|(T1X12));TMOD=(TMOD&(~T1C_T))
#define TM_SetT1Clock_SYSCLKDiv48()				AUXR2=(AUXR2|(T1X12));TMOD=(TMOD|(T1C_T))

// 设置TIMER值
#define TM_SetT0HighByte(x)			TH0=x
#define TM_SetT0LowByte(x)			TL0=x

#define TM_SetT1LowByte(x)			TL1=x
#define TM_SetT1HighByte(x)			TH1=x


// 设置TIMER输出引脚
#define TM_SetT0CKO_P34()			AUXR3=AUXR3&(~(T0PS0|T0PS1))
#define TM_SetT0CKO_P44()			AUXR3=(AUXR3&(~(T0PS0|T0PS1)))|(T0PS0)
#define TM_SetT0CKO_P46()			AUXR3=(AUXR3&(~(T0PS0|T0PS1)))|(T0PS1)
#define TM_SetT0CKO_P17()			AUXR3=AUXR3|(T0PS0|T0PS1)

#define TM_SetT1CKO_P35()			SFRPI=AUXR4_Page;AUXR4=AUXR4&(~(T1PS0|T1PS1));SFRPI=0
#define TM_SetT1CKO_P45()			SFRPI=AUXR4_Page;AUXR4=(AUXR4&(~(T1PS0|T1PS1)))|(T1PS0);SFRPI=0
#define TM_SetT1CKO_P36()			SFRPI=AUXR4_Page;AUXR4=(AUXR4&(~(T1PS0|T1PS1)))|(T1PS1);SFRPI=0
#define TM_SetT1CKO_P37()			SFRPI=AUXR4_Page;AUXR4=AUXR4|(T1PS0|T1PS1);SFRPI=0

// 设置TIMER CKO输出使能/禁止
#define TM_EnT0CKO()				SFRPI=AUXR11_Page;AUXR11=AUXR11|(T0CKOE);SFRPI=0
#define TM_EnT1CKO()				SFRPI=AUXR11_Page;AUXR11=AUXR11|(T1CKOE);SFRPI=0

#define TM_DisT0CKO()				SFRPI=AUXR11_Page;AUXR11=AUXR11&(~T0CKOE);SFRPI=0
#define TM_DisT1CKO()				SFRPI=AUXR11_Page;AUXR11=AUXR11&(~T1CKOE);SFRPI=0


/*
*************************************************************************************
*/

/*
//*************************************************************************************
//*  TIMER2
//*
//*************************************************************************************
*/
// 使能或关闭TIMER2
#define TM_DisableT2()			TR2=0
#define TM_EnableT2()			TR2=1

// 使能或关闭TL2
#define TM_DisableTL2()			T2MOD=T2MOD&(~TR2L)
#define TM_EnableTL2()			T2MOD=T2MOD|(TR2L)

// 使能或关闭硬件清TR2L
#define TM_DisableTR2LC()			T2MOD=T2MOD&(~TR2LC)
#define TM_EnableTR2LC()			T2MOD=T2MOD|(TR2LC)

// 选择TIMER2工作模式
#define TM_SetT2Mode_AutoRLandExI()			CP_RL2=0;T2MOD=T2MOD&(~T2MS0)
#define TM_SetT2Mode_AutoRLwithExI()		CP_RL2=0;T2MOD=T2MOD|(T2MS0)
#define TM_SetT2Mode_Capture()				CP_RL2=1;T2MOD=T2MOD&(~T2MS0)
#define TM_SetT2Mode_CapturewithAutoZero()	CP_RL2=1;T2MOD=T2MOD|(T2MS0)
#define TM_SetT2Mode_8bitPWM()				CP_RL2=0;T2MOD=T2MOD&(~T2MS0);T2MOD=T2MOD|(T2SPL);SFRPI=T2MOD1_Page;T2MOD1=T2MOD1|T2MS1;SFRPI=0
#define TM_SetT2Mode_DutyCapture()			CP_RL2=1;T2MOD=T2MOD&(~T2MS0);SFRPI=T2MOD1_Page;T2MOD1=T2MOD1|T2MS1;SFRPI=0

// 设置TIMER2分割模式
#define TM_EnT2Split()					T2MOD=T2MOD|(T2SPL)
#define TM_DisT2Split()					T2MOD=T2MOD&(~T2SPL)


// 设置TIMER2输出
#define TM_EnT2CKO()					T2MOD=T2MOD|(T2OE)
#define TM_DisT2CKO()					T2MOD=T2MOD&(~T2OE)

// 选择TIMER2时钟源
#define TM_SetT2Clock_SYSCLKDiv12()		C_T2=0;T2MOD=T2MOD&(~T2X12);SFRPI=T2MOD1_Page;T2MOD1=T2MOD1&(~T2CKS);SFRPI=0
#define TM_SetT2Clock_T2Pin()			C_T2=1;T2MOD=T2MOD&(~T2X12);SFRPI=T2MOD1_Page;T2MOD1=T2MOD1&(~T2CKS);SFRPI=0
#define TM_SetT2Clock_SYSCLK()			C_T2=0;T2MOD=T2MOD|(T2X12);SFRPI=T2MOD1_Page;T2MOD1=T2MOD1&(~T2CKS);SFRPI=0
#define TM_SetT2Clock_INT0ET()			C_T2=1;T2MOD=T2MOD|(T2X12);SFRPI=T2MOD1_Page;T2MOD1=T2MOD1&(~T2CKS);SFRPI=0
#define TM_SetT2Clock_S0TOF()			C_T2=0;T2MOD=T2MOD&(~T2X12);SFRPI=T2MOD1_Page;T2MOD1=T2MOD1|(T2CKS);SFRPI=0
#define TM_SetT2Clock_T0OF()			C_T2=1;T2MOD=T2MOD&(~T2X12);SFRPI=T2MOD1_Page;T2MOD1=T2MOD1|(T2CKS);SFRPI=0
#define TM_SetT2Clock_AC0ES()			C_T2=0;T2MOD=T2MOD|(T2X12);SFRPI=T2MOD1_Page;T2MOD1=T2MOD1|(T2CKS);SFRPI=0
#define TM_SetT2Clock_KBIET()			C_T2=1;T2MOD=T2MOD|(T2X12);SFRPI=T2MOD1_Page;T2MOD1=T2MOD1|(T2CKS);SFRPI=0

// 选择TIMER2分割模式下TL2时钟源
#define TM_SetTL2Clock_SYSCLKDiv12()	T2MOD=T2MOD&(~TL2X12_T2EIP);SFRPI=T2MOD1_Page;T2MOD1=T2MOD1&(~TL2CS);SFRPI=0
#define TM_SetTL2Clock_SYSCLK()			T2MOD=T2MOD|(TL2X12_T2EIP);SFRPI=T2MOD1_Page;T2MOD1=T2MOD1&(~TL2CS);SFRPI=0
#define TM_SetTL2Clock_S0TOF()			T2MOD=T2MOD&(~TL2X12_T2EIP);SFRPI=T2MOD1_Page;T2MOD1=T2MOD1|(TL2CS);SFRPI=0
#define TM_SetTL2Clock_INT0ET()			T2MOD=T2MOD|(TL2X12_T2EIP);SFRPI=T2MOD1_Page;T2MOD1=T2MOD1|(TL2CS);SFRPI=0

// 设置使能访问TF2L及其中断使能
#define TM_EnableAccessTF2L()				SFRPI=T2MOD1_Page;T2MOD1=T2MOD1|TL2IS;SFRPI=0;
#define TM_DisableAccessTF2L()				SFRPI=T2MOD1_Page;T2MOD1=T2MOD1&(~TL2IS);SFRPI=0;

// 选择TIMER2捕捉模式下的捕捉源
#define TM_SetT2Capture_T2EXPin()		SFRPI=T2MOD1_Page;T2MOD1=T2MOD1&(0xF8);SFRPI=0
#define TM_SetT2Capture_RXD0()			SFRPI=T2MOD1_Page;T2MOD1=(T2MOD1&(0xF8))|(CP2S0);SFRPI=0
#define TM_SetT2Capture_P60()			SFRPI=T2MOD1_Page;T2MOD1=(T2MOD1&(0xF8))|(CP2S1);SFRPI=0
#define TM_SetT2Capture_INT2ET()		SFRPI=T2MOD1_Page;T2MOD1=(T2MOD1&(0xF8))|(CP2S0|CP2S1);SFRPI=0
#define TM_SetT2Capture_ILRCO()			SFRPI=T2MOD1_Page;T2MOD1=(T2MOD1&(0xF8))|CP2S2;SFRPI=0
#define TM_SetT2Capture_AC0OUT()		SFRPI=T2MOD1_Page;T2MOD1=(T2MOD1&(0xF8))|(CP2S2|CP2S0);SFRPI=0
#define TM_SetT2Capture_KBIET()			SFRPI=T2MOD1_Page;T2MOD1=(T2MOD1&(0xF8))|(CP2S1|CP2S2);SFRPI=0
#define TM_SetT2Capture_TWI0SCL()		SFRPI=T2MOD1_Page;T2MOD1=T2MOD1|(CP2S0|CP2S1|CP2S2);SFRPI=0

// 设置TIMER2引脚
#define TM_SetT2CKOT2EX_P10P11()		SFRPI=AUXR4_Page;AUXR4=AUXR4&(~(T2PS1|T2PS0));SFRPI=0
#define TM_SetT2CKOT2EX_P32P33()		SFRPI=AUXR4_Page;AUXR4=(AUXR4&(~(T2PS1|T2PS0)))|(T2PS0);SFRPI=0
#define TM_SetT2CKOT2EX_P67P57()		SFRPI=AUXR4_Page;AUXR4=(AUXR4&(~(T2PS1|T2PS0)))|(T2PS1);SFRPI=0
#define TM_SetT2CKOT2EX_P45P44()		SFRPI=AUXR4_Page;AUXR4=AUXR4|((T2PS1|T2PS0));SFRPI=0

// 设置TIMER2引脚中断检测边沿
#define TM_EnableT2EX_DetectFalling()					EXEN2=1
#define TM_DisableT2EX_DetectFalling()					EXEN2=0
#define TM_EnableT2EX_DetectRising()					T2MOD=T2MOD|T2EXH
#define TM_DisableT2EX_DetectRising()					T2MOD=T2MOD&(~T2EXH)

// 设置TIMER2 T2CKO输出反向
#define TM_DisableT2CKO_Invert()		T2MOD=T2MOD&(~TR2LC)
#define TM_EnableT2CKO_Invert()			T2MOD=T2MOD|(TR2LC)

// 设置TIMER2值
#define TM_SetT2HighByte(x)			TH2=x
#define TM_SetT2LowByte(x)			TL2=x

#define TM_SetT2RLHighByte(x)		RCAP2H=x
#define TM_SetT2RLLowByte(x)		RCAP2L=x

/*
*************************************************************************************
*/

/*
//*************************************************************************************
//*  TIMER3
//*
//*************************************************************************************
*/
// 使能或关闭TIMER3
#define TM_DisableT3()			SFRPI=T3MOD_Page;TR3=0;SFRPI=0
#define TM_EnableT3()			SFRPI=T3MOD_Page;TR3=1;SFRPI=0

// 使能或关闭TL3
#define TM_DisableTL3()			SFRPI=T3MOD_Page;T3MOD=T3MOD&(~TR3L);SFRPI=0
#define TM_EnableTL3()			SFRPI=T3MOD_Page;T3MOD=T3MOD|(TR3L);SFRPI=0

// 使能或关闭硬件清TR3L
#define TM_DisableTR3LC()			SFRPI=T3MOD_Page;T3MOD=T3MOD&(~TR3LC);SFRPI=0
#define TM_EnableTR3LC()			SFRPI=T3MOD_Page;T3MOD=T3MOD|(TR3LC);SFRPI=0

// 选择TIMER3工作模式
#define TM_SetT3Mode_AutoRLandExI()			SFRPI=T3MOD_Page;CP_RL3=0;T3MOD=T3MOD&(~T3MS0);SFRPI=0
#define TM_SetT3Mode_AutoRLwithExI()		SFRPI=T3MOD_Page;CP_RL3=0;T3MOD=T3MOD|(T3MS0);SFRPI=0
#define TM_SetT3Mode_Capture()				SFRPI=T3MOD_Page;CP_RL3=1;T3MOD=T3MOD&(~T3MS0);SFRPI=0
#define TM_SetT3Mode_CapturewithAutoZero()	SFRPI=T3MOD_Page;CP_RL3=1;T3MOD=T3MOD|(T3MS0);SFRPI=0
#define TM_SetT3Mode_8bitPWM()				SFRPI=T3MOD_Page;CP_RL3=0;T3MOD=T3MOD&(~T3MS0);T3MOD=T3MOD|(T3SPL);SFRPI=T3MOD1_Page;T3MOD1=T3MOD1|T3MS1;SFRPI=0
#define TM_SetT3Mode_DutyCapture()			SFRPI=T3MOD_Page;CP_RL3=1;T3MOD=T3MOD&(~T3MS0);SFRPI=T3MOD1_Page;T3MOD1=T3MOD1|T3MS1;SFRPI=0

// 设置TIMER3分割模式
#define TM_EnT3Split()					SFRPI=T3MOD_Page;T3MOD=T3MOD|(T3SPL);SFRPI=0
#define TM_DisT3Split()					SFRPI=T3MOD_Page;T3MOD=T3MOD&(~T3SPL);SFRPI=0

// 设置TIMER3输出
#define TM_EnT3CKO()					SFRPI=T3MOD_Page;T3MOD=T3MOD|(T3OE);SFRPI=0
#define TM_DisT3CKO()					SFRPI=T3MOD_Page;T3MOD=T3MOD&(~T3OE);SFRPI=0

// 选择TIMER3时钟源
#define TM_SetT3Clock_SYSCLKDiv12()		SFRPI=T3MOD_Page;C_T3=0;T3MOD=T3MOD&(~T3X12);SFRPI=T3MOD1_Page;T3MOD1=T3MOD1&(~T3CKS);SFRPI=0
#define TM_SetT3Clock_T3Pin()			SFRPI=T3MOD_Page;C_T3=1;T3MOD=T3MOD&(~T3X12);SFRPI=T3MOD1_Page;T3MOD1=T3MOD1&(~T3CKS);SFRPI=0
#define TM_SetT3Clock_SYSCLK()			SFRPI=T3MOD_Page;C_T3=0;T3MOD=T3MOD|(T3X12);SFRPI=T3MOD1_Page;T3MOD1=T3MOD1&(~T3CKS);SFRPI=0
#define TM_SetT3Clock_INT1ET()			SFRPI=T3MOD_Page;C_T3=1;T3MOD=T3MOD|(T3X12);SFRPI=T3MOD1_Page;T3MOD1=T3MOD1&(~T3CKS);SFRPI=0
#define TM_SetT3Clock_S1TOF()			SFRPI=T3MOD_Page;C_T3=0;T3MOD=T3MOD&(~T3X12);SFRPI=T3MOD1_Page;T3MOD1=T3MOD1|(T3CKS);SFRPI=0
#define TM_SetT3Clock_T0OF()			SFRPI=T3MOD_Page;C_T3=1;T3MOD=T3MOD&(~T3X12);SFRPI=T3MOD1_Page;T3MOD1=T3MOD1|(T3CKS);SFRPI=0
#define TM_SetT3Clock_AC1ES()			SFRPI=T3MOD_Page;C_T3=0;T3MOD=T3MOD|(T3X12);SFRPI=T3MOD1_Page;T3MOD1=T3MOD1|(T3CKS);SFRPI=0
#define TM_SetT3Clock_T1OF()			SFRPI=T3MOD_Page;C_T3=1;T3MOD=T3MOD|(T3X12);SFRPI=T3MOD1_Page;T3MOD1=T3MOD1|(T3CKS);SFRPI=0

// 选择TIMER3分割模式下TL3时钟源
#define TM_SetTL3Clock_SYSCLKDiv12()	SFRPI=T3MOD_Page;T3MOD=T3MOD&(~TL3X12_T3EIP);SFRPI=T3MOD1_Page;T3MOD1=T3MOD1&(~TL3CS);SFRPI=0
#define TM_SetTL3Clock_SYSCLK()			SFRPI=T3MOD_Page;T3MOD=T3MOD|(TL3X12_T3EIP);SFRPI=T3MOD1_Page;T3MOD1=T3MOD1&(~TL3CS);SFRPI=0
#define TM_SetTL3Clock_S1TOF()			SFRPI=T3MOD_Page;T3MOD=T3MOD&(~TL3X12_T3EIP);SFRPI=T3MOD1_Page;T3MOD1=T3MOD1|(TL3CS);SFRPI=0
#define TM_SetTL3Clock_INT1ET()			SFRPI=T3MOD_Page;T3MOD=T3MOD|(TL3X12_T3EIP);SFRPI=T3MOD1_Page;T3MOD1=T3MOD1|(TL3CS);SFRPI=0

// 选择TIMER3捕捉模式下的捕捉源
#define TM_SetT3Capture_T3EXPin()		SFRPI=T3MOD1_Page;T3MOD1=T3MOD1&(0xF8);SFRPI=0
#define TM_SetT3Capture_INT0ET()		SFRPI=T3MOD1_Page;T3MOD1=(T3MOD1&(0xF8))|(CP3S0);SFRPI=0
#define TM_SetT3Capture_P60()			SFRPI=T3MOD1_Page;T3MOD1=(T3MOD1&(0xF8))|(CP3S1);SFRPI=0
#define	TM_SetT3Capture_nSS()			SFRPI=T3MOD1_Page;T3MOD1=(T3MOD1&(0xF8))|(CP3S0|CP3S1);SFRPI=0
#define TM_SetT3Capture_KBIET()			SFRPI=T3MOD1_Page;T3MOD1=(T3MOD1&(0xF8))|(CP3S2);SFRPI=0
#define TM_SetT3Capture_AC0OUT()		SFRPI=T3MOD1_Page;T3MOD1=(T3MOD1&(0xF8))|(CP3S0|CP3S2);SFRPI=0
#define TM_SetT3Capture_AC1OUT()		SFRPI=T3MOD1_Page;T3MOD1=(T3MOD1&(0xF8))|(CP3S1|CP3S2);SFRPI=0
#define TM_SetT3Capture_ILRCO()			SFRPI=T3MOD1_Page;T3MOD1=T3MOD1|(CP3S0|CP3S1|CP3S2);SFRPI=0

// 设置TIMER3引脚
#define TM_SetT3CKOT3EX_P46P00()		SFRPI=AUXR8_Page;AUXR8=AUXR8&(~(T3PS1|T3PS0));SFRPI=0
#define TM_SetT3CKOT3EX_P33P32()		SFRPI=AUXR8_Page;AUXR8=(AUXR8&(~(T3PS1|T3PS0)))|(T3PS0);SFRPI=0
#define TM_SetT3CKOT3EX_P21P20()		SFRPI=AUXR8_Page;AUXR8=(AUXR8&(~(T3PS1|T3PS0)))|(T3PS1);SFRPI=0
#define TM_SetT3CKOT3EX_P66P65()		SFRPI=AUXR8_Page;AUXR8=AUXR8|((T3PS1|T3PS0));SFRPI=0

// 设置TIMER3引脚中断检测边沿
#define TM_EnableT3EX_DetectFalling()					SFRPI=T3CON_Page;EXEN3=1;SFRPI=0
#define TM_DisableT3EX_DetectFalling()					SFRPI=T3CON_Page;EXEN3=0;SFRPI=0
#define TM_EnableT3EX_DetectRising()					SFRPI=T3MOD_Page;T3MOD=T3MOD|T3EXH;SFRPI=0
#define TM_DisableT3EX_DetectRising()					SFRPI=T3MOD_Page;T3MOD=T3MOD&(~T3EXH);SFRPI=0

// 设置TIMER3 T3EXI输入反向
#define TM_DisableT3EXI_Invert()		SFRPI=T3MOD1_Page;T3MOD1=T3MOD1|(TL3IS);SFRPI=T3MOD_Page;T3MOD=T3MOD&(~T3EIP);SFRPI=T3MOD1_Page;T3MOD1=T3MOD1&(~TL3IS);SFRPI=0
#define TM_EnableT3EXI_Invert()			SFRPI=T3MOD1_Page;T3MOD1=T3MOD1|(TL3IS);SFRPI=T3MOD_Page;T3MOD=T3MOD|(T3EIP);SFRPI=T3MOD1_Page;T3MOD1=T3MOD1&(~TL3IS);SFRPI=0

// 设置TIMER3值
#define TM_SetT3HighByte(x)			SFRPI=TH3_Page;TH3=x;SFRPI=0
#define TM_SetT3LowByte(x)			SFRPI=TL3_Page;TL3=x;SFRPI=0

#define TM_SetT3RLHighByte(x)		SFRPI=RCAP3H_Page;RCAP3H=x;SFRPI=0
#define TM_SetT3RLLowByte(x)		SFRPI=RCAP3L_Page;RCAP3L=x;SFRPI=0

/*
*************************************************************************************
*/


/*
//*************************************************************************************
//*  TIMER 全局控制
//*
//*************************************************************************************
*/
#define	PTM0_GLOBAL_BIT  		0x01
#define	PCA11_GLOBAL_BIT  		0x02
#define	TIMER3_GLOBAL_BIT  		0x40
#define	TIMER2_GLOBAL_BIT  		0x80

// 全局使能TIMER
#define TM_GlobalStart(x)				SFRPI=TREN0_Page;TREN0=TREN0|x;SFRPI=0

// 全局触发Timer重载
#define TM_GlobalReload(x)				SFRPI=TRLC0_Page;TRLC0=TRLC0|x;SFRPI=0

// 全局停止TIMER
#define TM_GlobalSTOP(x)				SFRPI=TSPC0_Page;TSPC0=TSPC0|x;SFRPI=0

/*
*************************************************************************************
*/


/*
//*************************************************************************************
//*  IO PORT
//*
//*************************************************************************************
*/
// 设置P0脚模式
#define PORT_SetP0OpenDrainPu(x)			P0M0=P0M0|(x);SFRPI=P0M1_Page;P0M1=P0M1|(x);SFRPI=0
#define PORT_SetP0PushPull(x)				P0M0=P0M0|(x);SFRPI=P0M1_Page;P0M1=P0M1&(~(x));SFRPI=0
#define PORT_SetP0AInputOnly(x)				P0M0=P0M0&(~(x));SFRPI=P0M1_Page;P0M1=P0M1|(x);SFRPI=0
#define PORT_SetP0OpenDrain(x)				P0M0=P0M0&(~(x));SFRPI=P0M1_Page;P0M1=P0M1&(~(x));SFRPI=0
// 设置P0输出能力
#define PORT_P00P01P02P03_HighDrive()		SFRPI=PDRVC0_Page;PDRVC0=PDRVC0&(~(P0DC0));SFRPI=0
#define PORT_P00P01P02P03_LowDrive()		SFRPI=PDRVC0_Page;PDRVC0=PDRVC0|((P0DC0));SFRPI=0
#define PORT_P04P05P06P07_HighDrive()		SFRPI=PDRVC0_Page;PDRVC0=PDRVC0&(~(P0DC1));SFRPI=0
#define PORT_P04P05P06P07_LowDrive()		SFRPI=PDRVC0_Page;PDRVC0=PDRVC0|((P0DC1));SFRPI=0
#define PORT_P0_EnFastDrive(x)				SFRPI=P0FDC_Page;P0FDC=P0FDC|((x));SFRPI=0
#define PORT_P0_DisFastDrive(x)				SFRPI=P0FDC_Page;P0FDC=P0FDC&(~(x));SFRPI=0

// 设置P1引脚模式
#define PORT_SetP1OpenDrainPu(x)			P1M0=P1M0|(x);P1M1=P1M1|(x)
#define PORT_SetP1PushPull(x)				P1M0=P1M0|(x);P1M1=P1M1&(~(x))
#define PORT_SetP1AInputOnly(x)				P1M0=P1M0&(~(x));P1M1=P1M1|(x)
#define PORT_SetP1OpenDrain(x)				P1M0=P1M0&(~(x));P1M1=P1M1&(~(x))
// 设置P1口输出能力
#define PORT_P10P11P12P13_HighDrive()		SFRPI=PDRVC0_Page;PDRVC0=PDRVC0&(~(P1DC0));SFRPI=0
#define PORT_P10P11P12P13_LowDrive()		SFRPI=PDRVC0_Page;PDRVC0=PDRVC0|((P1DC0));SFRPI=0
#define PORT_P14P15P16P17_HighDrive()		SFRPI=PDRVC0_Page;PDRVC0=PDRVC0&(~(P1DC1));SFRPI=0
#define PORT_P14P15P16P17_LowDrive()		SFRPI=PDRVC0_Page;PDRVC0=PDRVC0|((P1DC1));SFRPI=0
#define PORT_P1_EnFastDrive(x)				SFRPI=P1FDC_Page;P1FDC=P1FDC|((x));SFRPI=0
#define PORT_P1_DisFastDrive(x)				SFRPI=P1FDC_Page;P1FDC=P1FDC&(~(x));SFRPI=0

// 设置P2引脚模式
#define PORT_SetP2OpenDrainPu(x)			P2M0=P2M0|(x); SFRPI=P2M1_Page;P2M1=P2M1|(x) ;SFRPI=0
#define PORT_SetP2PushPull(x)				P2M0=P2M0|(x); SFRPI=P2M1_Page;P2M1=P2M1&(~(x));SFRPI=0
#define PORT_SetP2AInputOnly(x)				P2M0=P2M0&(~(x));SFRPI=P2M1_Page;P2M1=P2M1|(x) ;SFRPI=0
#define PORT_SetP2OpenDrain(x)				P2M0=P2M0&(~(x));SFRPI=P2M1_Page;P2M1=P2M1&(~(x));SFRPI=0
// 设置P2口输出能力
#define PORT_P20P21P22P23_HighDrive()		SFRPI=PDRVC0_Page;PDRVC0=PDRVC0&(~(P2DC0));SFRPI=0
#define PORT_P20P21P22P23_LowDrive()		SFRPI=PDRVC0_Page;PDRVC0=PDRVC0|((P2DC0));SFRPI=0
#define PORT_P24P25P26P27_HighDrive()		SFRPI=PDRVC0_Page;PDRVC0=PDRVC0&(~(P2DC1));SFRPI=0
#define PORT_P24P25P26P27_LowDrive()		SFRPI=PDRVC0_Page;PDRVC0=PDRVC0|((P2DC1));SFRPI=0
#define PORT_P2_EnFastDrive(x)				SFRPI=P2FDC_Page;P2FDC=P2FDC|((x));SFRPI=0
#define PORT_P2_DisFastDrive(x)				SFRPI=P2FDC_Page;P2FDC=P2FDC&(~(x));SFRPI=0

// 设置P3引脚模式
#define PORT_SetP3QuasiBi(x)				P3M0=P3M0&(~(x));P3M1=P3M1&(~(x));SFRPI=P3M2_Page;P3M2=P3M2&(~(x));SFRPI=0
#define PORT_SetP3PushPull(x)				P3M0=P3M0&(~(x));P3M1=P3M1|(x);SFRPI=P3M2_Page;P3M2=P3M2&(~(x));SFRPI=0
#define PORT_SetP3InputOnly(x)				P3M0=P3M0|(x);P3M1=P3M1&(~(x));SFRPI=P3M2_Page;P3M2=P3M2&(~(x));SFRPI=0
#define PORT_SetP3OpenDrain(x)				P3M0=P3M0|(x);P3M1=P3M1|(x);SFRPI=P3M2_Page;P3M2=P3M2&(~(x));SFRPI=0
#define PORT_SetP3AInputOnly(x)				P3M0=P3M0&(~(x));P3M1=P3M1&(~(x));SFRPI=P3M2_Page;P3M2=P3M2|(x);SFRPI=0

// 设置P3口输出能力
#define PORT_P30P31P32P33_HighDrive()		SFRPI=PDRVC0_Page;PDRVC0=PDRVC0&(~(P3DC0));SFRPI=0
#define PORT_P30P31P32P33_LowDrive()		SFRPI=PDRVC0_Page;PDRVC0=PDRVC0|((P3DC0));SFRPI=0
#define PORT_P34P35P36P37_HighDrive()		SFRPI=PDRVC0_Page;PDRVC0=PDRVC0&(~(P3DC1));SFRPI=0
#define PORT_P34P35P36P37_LowDrive()		SFRPI=PDRVC0_Page;PDRVC0=PDRVC0|((P3DC1));SFRPI=0
#define PORT_P3_EnFastDrive(x)				SFRPI=P3FDC_Page;P3FDC=P3FDC|((x));SFRPI=0
#define PORT_P3_DisFastDrive(x)				SFRPI=P3FDC_Page;P3FDC=P3FDC&(~(x));SFRPI=0

// 设置P4引脚模式
#define PORT_SetP4OpenDrainPu(x)			P4M0=P4M0|(x); SFRPI=P4M1_Page;P4M1=P4M1|(x) ;SFRPI=0
#define PORT_SetP4PushPull(x)				P4M0=P4M0|(x); SFRPI=P4M1_Page;P4M1=P4M1&(~(x));SFRPI=0
#define PORT_SetP4AInputOnly(x)				P4M0=P4M0&(~(x));SFRPI=P4M1_Page;P4M1=P4M1|(x) ;SFRPI=0
#define PORT_SetP4OpenDrain(x)				P4M0=P4M0&(~(x));SFRPI=P4M1_Page;P4M1=P4M1&(~(x));SFRPI=0
// 设置P4口输出能力
#define PORT_P44P45P46_HighDrive()			SFRPI=PDRVC1_Page;PDRVC1=PDRVC1&(~(P4DC1));SFRPI=0
#define PORT_P44P45P46_LowDrive()			SFRPI=PDRVC1_Page;PDRVC1=PDRVC1|((P4DC1));SFRPI=0
#define PORT_P40P41P42P43_HighDrive()		SFRPI=PDRVC1_Page;PDRVC1=PDRVC1&(~(P4DC0));SFRPI=0
#define PORT_P40P41P42P43_LowDrive()		SFRPI=PDRVC1_Page;PDRVC1=PDRVC1|((P4DC0));SFRPI=0
#define PORT_P4_EnFastDrive(x)				SFRPI=P4FDC_Page;P4FDC=P4FDC|((x));SFRPI=0
#define PORT_P4_DisFastDrive(x)				SFRPI=P4FDC_Page;P4FDC=P4FDC&(~(x));SFRPI=0

// 设置P6引脚模式
#define PORT_SetP6OpenDrainPu(x)			SFRPI=P6M0_Page;P6M0=P6M0|(x); SFRPI=P6M1_Page;P6M1=P6M1|(x) ;SFRPI=0 
#define PORT_SetP6PushPull(x)				SFRPI=P6M0_Page;P6M0=P6M0|(x); SFRPI=P6M1_Page;P6M1=P6M1&(~(x));SFRPI=0 
#define PORT_SetP6AInputOnly(x)				SFRPI=P6M0_Page;P6M0=P6M0&(~(x));SFRPI=P6M1_Page;P6M1=P6M1|(x) ;SFRPI=0
#define PORT_SetP6OpenDrain(x)				SFRPI=P6M0_Page;P6M0=P6M0&(~(x));SFRPI=P6M1_Page;P6M1=P6M1&(~(x));SFRPI=0

// 设置P60输出快速驱动
#define PORT_P60EnFastDrive()				SFRPI=AUXR10_Page;AUXR10=AUXR10|P60FD;SFRPI=0
#define	PORT_P60DisFastDrive()				SFRPI=AUXR10_Page;AUXR10=AUXR10&~P60FD;SFRPI=0

// 引脚功能复用

// 设置T0/T0CKO 引脚
#define PORT_SetT0CKO_P34()						AUXR3=AUXR3&(~(T0PS0|T0PS1))
#define PORT_SetT0CKO_P44()						AUXR3=(AUXR3&(~(T0PS0|T0PS1)))|(T0PS0)
#define PORT_SetT0CKO_P22()						AUXR3=(AUXR3&(~(T0PS0|T0PS1)))|(T0PS1)
#define PORT_SetT0CKO_P17()						AUXR3=AUXR3|(T0PS0|T0PS1)

// 设置UART0 的RXD0/TXD0 引脚
#define PORT_SetRXD0TXD0_P30P31()				SFRPI=AUXR10_Page;AUXR10=AUXR10&(~S0PS1);SFRPI=0;	AUXR3=AUXR3&(~S0PS0)
#define PORT_SetRXD0TXD0_P44P45()				SFRPI=AUXR10_Page;AUXR10=AUXR10&(~S0PS1);SFRPI=0;	AUXR3=AUXR3|(S0PS0)
#define PORT_SetRXD0TXD0_P31P30()				SFRPI=AUXR10_Page;AUXR10=AUXR10|(S0PS1);SFRPI=0;	AUXR3=AUXR3&(~S0PS0)
#define PORT_SetRXD0TXD0_P17P22()				SFRPI=AUXR10_Page;AUXR10=AUXR10|(S0PS1);SFRPI=0;	AUXR3=AUXR3|(S0PS0)

// 选择TWI0 所用的IO口 SCL/SDA
#define PORT_SetTWI0SCLTWI0SDA_P40P41()			AUXR3=(AUXR3&(~(TWIPS1|TWIPS0)))
#define PORT_SetTWI0SCLTWI0SDA_P60P61()			AUXR3=(AUXR3&(~(TWIPS1|TWIPS0)))|TWIPS0
#define PORT_SetTWI0SCLTWI0SDA_P31P30()			AUXR3=(AUXR3&(~(TWIPS1|TWIPS0)))|TWIPS1
#define PORT_SetTWI0SCLTWI0SDA_P22P24()			AUXR3=(AUXR3|(TWIPS1|TWIPS0))

// 设置T2 引脚
#define PORT_SetT2CKOT2EX_P10P11()				SFRPI=AUXR4_Page;AUXR4=AUXR4&(~(T2PS1|T2PS0));SFRPI=0
#define PORT_SetT2CKOT2EX_P32P33()				SFRPI=AUXR4_Page;AUXR4=(AUXR4&(~(T2PS1|T2PS0)))|(T2PS0);SFRPI=0
#define PORT_SetT2CKOT2EX_P60P35()				SFRPI=AUXR4_Page;AUXR4=(AUXR4&(~(T2PS1|T2PS0)))|(T2PS1);SFRPI=0
#define PORT_SetT2CKOT2EX_P45P44()				SFRPI=AUXR4_Page;AUXR4=AUXR4|((T2PS1|T2PS0));SFRPI=0

// 设置T1 引脚
#define PORT_SetT1CKO_P35()						SFRPI=AUXR4_Page;AUXR4=AUXR4&(~(T1PS0|T1PS1));SFRPI=0
#define PORT_SetT1CKO_P45()						SFRPI=AUXR4_Page;AUXR4=(AUXR4&(~(T1PS0|T1PS1)))|(T1PS0);SFRPI=0
#define PORT_SetT1CKO_P17()						SFRPI=AUXR4_Page;AUXR4=(AUXR4&(~(T1PS0|T1PS1)))|(T1PS1);SFRPI=0
#define PORT_SetT1CKO_P33()						SFRPI=AUXR4_Page;AUXR4=AUXR4|(T1PS0|T1PS1);SFRPI=0

// 设置AC0OUT输出
#define PORT_SetAC0OUT_Disable()				SFRPI=AUXR4_Page;AUXR4=AUXR4&(~(AC0OE));SFRPI=0
#define PORT_SetAC0OUT_P45()					SFRPI=AUXR4_Page;AUXR4=AUXR4|AC0OE;SFRPI=0

// 设置AC1OUT输出
#define PORT_SetAC1OUT_Disable()				SFRPI=AUXR4_Page;AUXR4=AUXR4&(~(AC1OE));SFRPI=0
#define PORT_SetAC1OUT_P05()					SFRPI=AUXR4_Page;AUXR4=AUXR4|AC1OE;SFRPI=0

// 设置PWM2A/PWM2B的引脚
#define PORT_SetPWM2APWM2B_P40P41()				SFRPI=AUXR5_Page;AUXR5=AUXR5&(~C0PPS1);SFRPI=0
#define PORT_SetPWM2APWM2B_P34P35()				SFRPI=AUXR5_Page;AUXR5=AUXR5|(C0PPS1);SFRPI=0

// 设置PWM0A/PWM0B的引脚
#define PORT_SetPWM0APWM0B_P16P17()				SFRPI=AUXR5_Page;AUXR5=AUXR5&(~C0PPS0);SFRPI=0
#define PORT_SetPWM0APWM0B_P60P61()				SFRPI=AUXR5_Page;AUXR5=AUXR5|(C0PPS0);SFRPI=0

// 设置PCA1 ECI的引脚
#define PORT_SetPCA1ECI_PTM0ECI()				SFRPI=AUXR5_Page;AUXR5=AUXR5&(~EC1IPS0);SFRPI=0
#define PORT_SetPCA1ECI_P15()					SFRPI=AUXR5_Page;AUXR5=AUXR5|(EC1IPS0);SFRPI=0

// 设置PTM0 ECI的引脚
#define PORT_SetPTM0ECI_P02()					SFRPI=AUXR5_Page;AUXR5=AUXR5&(~ECIPS0);SFRPI=0
#define PORT_SetPTM0ECI_P16()					SFRPI=AUXR5_Page;AUXR5=AUXR5|(ECIPS0);SFRPI=0

// 设置PTM0 C0CKO的引脚
#define PORT_SetC0CKO_P47()						SFRPI=AUXR5_Page;AUXR5=AUXR5&(~C0COPS);SFRPI=0
#define PORT_SetC0CKO_P33()						SFRPI=AUXR5_Page;AUXR5=AUXR5|(C0COPS);SFRPI=0

// 设置KBI0~3的引脚
#define PORT_SetKBI0123_P10P11P12P13()			SFRPI=AUXR6_Page;AUXR6=AUXR6&(~(KBILPS0|KBILPS1));SFRPI=0
#define PORT_SetKBI0123_P30P31P32P33()			SFRPI=AUXR6_Page;AUXR6=(AUXR6&(~(KBILPS0|KBILPS1)))|KBILPS0;SFRPI=0
#define PORT_SetKBI0123_P01P02P05P07()			SFRPI=AUXR6_Page;AUXR6=(AUXR6&(~(KBILPS0|KBILPS1)))|KBILPS1;SFRPI=0
#define PORT_SetKBI0123_P40P41P44P45()			SFRPI=AUXR6_Page;AUXR6=AUXR6|(KBILPS1|KBILPS0);SFRPI=0

// 设置KBI4~7的引脚
#define PORT_SetKBI4567_P14P15P16P17()			SFRPI=AUXR6_Page;AUXR6=AUXR6&(~(KBIHPS0|KBIHPS1));SFRPI=0
#define PORT_SetKBI4567_P34P35P16P17()			SFRPI=AUXR6_Page;AUXR6=(AUXR6&(~(KBIHPS0|KBIHPS1)))|KBIHPS0;SFRPI=0
#define PORT_SetKBI4567_P22P23P24P26()			SFRPI=AUXR6_Page;AUXR6=(AUXR6&(~(KBIHPS0|KBIHPS1)))|KBIHPS1;SFRPI=0
#define PORT_SetKBI4567_P60P61P16P17()			SFRPI=AUXR6_Page;AUXR6=AUXR6|(KBIHPS1|KBIHPS0);SFRPI=0

// 设置UART0,1 的SPI MASTER的SnMI（MISO）引脚
#define PORT_SetS0MIS1MI_P16P10()				SFRPI=AUXR6_Page;AUXR6=AUXR6&(~(SnMIPS));SFRPI=0
#define PORT_SetS0MIS1MI_P33P35()				SFRPI=AUXR6_Page;AUXR6=AUXR6|((SnMIPS));SFRPI=0

// 设置 S0CKO 引脚
#define PORT_SetS0CKO_P47()						SFRPI=AUXR6_Page;AUXR6=AUXR6&(~S0COPS);SFRPI=0
#define PORT_SetS0CKO_P44()						SFRPI=AUXR6_Page;AUXR6=AUXR6|S0COPS;SFRPI=0

// 设置PTM0 C0CKO
#define PORT_SetC0CKO_Disable()					SFRPI=AUXR7_Page;AUXR7=AUXR7&(~C0CKOE);SFRPI=0
#define PORT_SetC0CKO_Enable()					SFRPI=AUXR7_Page;AUXR7=AUXR7|(C0CKOE);SFRPI=0

// 设置PCA1 C1CKO
#define PORT_SetC1CKO_Disable()					SFRPI=AUXR7_Page;AUXR7=AUXR7&(~C1CKOE);SFRPI=0
#define PORT_SetC1CKO_Enable()					SFRPI=AUXR7_Page;AUXR7=AUXR7|(C1CKOE);SFRPI=0


// 设置PCA1 通道1输入引脚
#define PORT_SetPCA1CH1Input_C1EX1()			SFRPI=AUXR8_Page;AUXR8=AUXR8&(~(C1ICS1));SFRPI=0
#define PORT_SetPCA1CH1Input_T2EXI()			SFRPI=AUXR8_Page;AUXR8=AUXR8|((C1ICS1));SFRPI=0

// 设置PCA1 通道0输入引脚
#define PORT_SetPCA1CH0Input_C1EX0()			SFRPI=AUXR8_Page;AUXR8=AUXR8&(~(C1ICS0));SFRPI=0
#define PORT_SetPCA1CH0Input_T3EXI()			SFRPI=AUXR8_Page;AUXR8=AUXR8|((C1ICS0));SFRPI=0

// 设置S1CKO 输出引脚
#define PORT_SetS1CKO_P47()						SFRPI=AUXR8_Page;AUXR8=AUXR8&(~S1COPS);SFRPI=0
#define PORT_SetS1CKO_P45()						SFRPI=AUXR8_Page;AUXR8=AUXR8|S1COPS;SFRPI=0

// 设置T3引脚
#define PORT_SetT3CKOT3EX_P33P34()				SFRPI=AUXR8_Page;AUXR8=AUXR8&(~(T3PS1|T3PS0));SFRPI=0
#define PORT_SetT3CKOT3EX_P33P32()				SFRPI=AUXR8_Page;AUXR8=(AUXR8&(~(T3PS1|T3PS0)))|(T3PS0);SFRPI=0
#define PORT_SetT3CKOT3EX_P02P01()				SFRPI=AUXR8_Page;AUXR8=(AUXR8&(~(T3PS1|T3PS0)))|(T3PS1);SFRPI=0
#define PORT_SetT3CKOT3EX_P60P61()				SFRPI=AUXR8_Page;AUXR8=AUXR8|((T3PS1|T3PS0));SFRPI=0

// 选择SID/STWI的引脚
#define PORT_SetSTWISCLSTWISDA_nINT1S0MI()		SFRPI=AUXR9_Page;AUXR9=AUXR9&(~(SIDPS1|SIDPS0));SFRPI=0
#define PORT_SetSTWISCLSTWISDA_TWI0SCLTWI0SDA()	SFRPI=AUXR9_Page;AUXR9=(AUXR9&(~(SIDPS1|SIDPS0)))|SIDPS0;SFRPI=0
#define PORT_SetSTWISCLSTWISDA_TWI1SCLTWI1SDA()	SFRPI=AUXR9_Page;AUXR9=(AUXR9&(~(SIDPS1|SIDPS0)))|SIDPS1;SFRPI=0
#define PORT_SetSTWISCLSTWISDA_T2EXIT3EXI()		SFRPI=AUXR9_Page;AUXR9=AUXR9|(SIDPS1|SIDPS0);SFRPI=0


// 选择UART1的RXD1/TXD1引脚
#define PORT_SetRXD1TXD1_P12P13()				SFRPI=AUXR9_Page;AUXR9=AUXR9&(~(S1PS1|S1PS0));SFRPI=0
#define PORT_SetRXD1TXD1_P60P61()				SFRPI=AUXR9_Page;AUXR9=(AUXR9&(~(S1PS1|S1PS0)))|S1PS0;SFRPI=0
#define PORT_SetRXD1TXD1_P10P11()				SFRPI=AUXR9_Page;AUXR9=(AUXR9&(~(S1PS1|S1PS0)))|S1PS1;SFRPI=0
#define PORT_SetRXD1TXD1_P34P35()				SFRPI=AUXR9_Page;AUXR9=AUXR9|(S1PS1|S1PS0);SFRPI=0

// 选择SPI 的引脚 nSS/MOSI/MISO/SPICLK
#define PORT_SetSPInSSMOSIMISOSPICLK_P14P15P16P17()			SFRPI=AUXR10_Page;AUXR10=AUXR10&(~(SPIPS0|SPIPS1));SFRPI=0
#define PORT_SetSPInSSMOSIMISOSPICLK_P01P02P41P40()			SFRPI=AUXR10_Page;AUXR10=(AUXR10&(~(SPIPS0|SPIPS1)))|SPIPS0;SFRPI=0
#define PORT_SetSPInSSMOSIMISOSPICLK_P33P15P16P17()			SFRPI=AUXR10_Page;AUXR10=(AUXR10&(~(SPIPS0|SPIPS1)))|SPIPS1;SFRPI=0
#define PORT_SetSPInSSMOSIMISOSPICL3_P17P35P34P33()			SFRPI=AUXR10_Page;AUXR10=AUXR10|(SPIPS0|SPIPS1);SFRPI=0

// 设置P60
#define PORT_SetP60_P60()						SFRPI=AUXR10_Page;AUXR10=(AUXR10&(~(P60OC1|P60OC0)));SFRPI=0
#define PORT_SetP60_MCK()						SFRPI=AUXR10_Page;AUXR10=(AUXR10&(~(P60OC1|P60OC0)))|P60OC0;SFRPI=0
#define PORT_SetP60_MCKDiv2()					SFRPI=AUXR10_Page;AUXR10=(AUXR10&(~(P60OC1|P60OC0)))|P60OC1;SFRPI=0
#define PORT_SetP60_MCKDiv4()					SFRPI=AUXR10_Page;AUXR10=(AUXR10|(P60OC1|P60OC0));SFRPI=0

// 设置P60 driver
#define PORT_SetP60Driver_Default()				SFRPI=AUXR10_Page;AUXR10=AUXR10&(~P60FD);SFRPI=0
#define	PORT_SetP60Driver_Fast()				SFRPI=AUXR10_Page;AUXR10=AUXR10|P60FD;SFRPI=0

// 选择TWI1的引脚
#define PORT_SetTWI1SCLTWI1SDA_P10P11()			SFRPI=AUXR11_Page;AUXR11=(AUXR11&(~(I2C1PS1|I2C1PS0)));SFRPI=0
#define PORT_SetTWI1SCLTWI1SDA_P60P61()			SFRPI=AUXR11_Page;AUXR11=(AUXR11&(~(I2C1PS1|I2C1PS0)))|I2C1PS0;SFRPI=0
#define PORT_SetTWI1SCLTWI1SDA_P30P31()			SFRPI=AUXR11_Page;AUXR11=(AUXR11&(~(I2C1PS1|I2C1PS0)))|I2C1PS1;SFRPI=0
#define PORT_SetTWI1SCLTWI1SDA_TWI0SCLSDA()		SFRPI=AUXR11_Page;AUXR11=(AUXR11|(I2C1PS1|I2C1PS0));SFRPI=0

// 选择UART1的RXD1引脚
#define PORT_SetRXD1_ByAUXR9()					SFRPI=AUXR11_Page;AUXR11=AUXR11&(~(RX1S0));SFRPI=0
#define PORT_SetRXD1_AC0OUT()					SFRPI=AUXR11_Page;AUXR11=AUXR11|RX1S0;SFRPI=0

// 设置PDTXOE
#define PORT_SetPDTXOE_P15()					SFRPI=AUXR12_Page;AUXR11=(AUXR11&(~(PDOES1|PDOES0)));SFRPI=0
#define PORT_SetPDTXOE_P33()					SFRPI=AUXR12_Page;AUXR11=(AUXR11&(~(PDOES1|PDOES0)))|PDOES0;SFRPI=0
#define PORT_SetPDTXOE_P61()					SFRPI=AUXR12_Page;AUXR11=(AUXR11&(~(PDOES1|PDOES0)))|PDOES1;SFRPI=0
#define PORT_SetPDTXOE_P32()					SFRPI=AUXR12_Page;AUXR11=(AUXR11|(PDOES1|PDOES0));SFRPI=0

// 设置PTM0 输出引脚
#define PORT_SetCEX0_P22()						SFRPI=AUXR16_Page;AUXR16=AUXR16&(~C0OPS0);SFRPI=0
#define PORT_SetCEX0_P40()						SFRPI=AUXR16_Page;AUXR16=AUXR16|C0OPS0;SFRPI=0
#define PORT_SetCEX1_P23()						SFRPI=AUXR16_Page;AUXR16=AUXR16&(~C0OPS1);SFRPI=0
#define PORT_SetCEX1_P33()						SFRPI=AUXR16_Page;AUXR16=AUXR16|C0OPS1;SFRPI=0
#define PORT_SetCEX2_P24()						SFRPI=AUXR16_Page;AUXR16=AUXR16&(~C0OPS2);SFRPI=0
#define PORT_SetCEX2_P41()						SFRPI=AUXR16_Page;AUXR16=AUXR16|C0OPS2;SFRPI=0
#define PORT_SetCEX3_P05()						SFRPI=AUXR16_Page;AUXR16=AUXR16&(~C0OPS3);SFRPI=0
#define PORT_SetCEX3_P34()						SFRPI=AUXR16_Page;AUXR16=AUXR16|C0OPS3;SFRPI=0
#define PORT_SetCEX4_P26()						SFRPI=AUXR16_Page;AUXR16=AUXR16&(~C0OPS4);SFRPI=0
#define PORT_SetCEX4_P32()						SFRPI=AUXR16_Page;AUXR16=AUXR16|C0OPS4;SFRPI=0
#define PORT_SetCEX5_P07()						SFRPI=AUXR16_Page;AUXR16=AUXR16&(~C0OPS5);SFRPI=0
#define PORT_SetCEX5_P35()						SFRPI=AUXR16_Page;AUXR16=AUXR16|C0OPS5;SFRPI=0

// 设置PCA1 输出引脚
#define PORT_SetC1EX0_P60()						SFRPI=AUXR17_Page;AUXR17=AUXR17&(~C1OPS0);SFRPI=0
#define PORT_SetC1EX0_P30()						SFRPI=AUXR17_Page;AUXR17=AUXR17|C1OPS0;SFRPI=0
#define PORT_SetC1EX1_P61()						SFRPI=AUXR17_Page;AUXR17=AUXR17&(~C1OPS1);SFRPI=0
#define PORT_SetC1EX1_P31()						SFRPI=AUXR17_Page;AUXR17=AUXR17|C1OPS1;SFRPI=0

// 设置外部中断引脚
#define PORT_SetINT0_P32()						XICFG=XICFG&(~(INT0IS0|INT0IS1));SFRPI =XICFG1_Page;XICFG1=XICFG1&(~INT0IS2);SFRPI=0
#define PORT_SetINT0_P30()						XICFG=(XICFG&(~INT0IS1))|INT0IS0;SFRPI =XICFG1_Page;XICFG1=XICFG1&(~INT0IS2);SFRPI=0
#define PORT_SetINT0_P34()						XICFG=(XICFG&(~INT0IS0))|INT0IS1;SFRPI =XICFG1_Page;XICFG1=XICFG1&(~INT0IS2);SFRPI=0
#define PORT_SetINT0_P40()						XICFG=XICFG|(INT0IS0|INT0IS1);SFRPI =XICFG1_Page;XICFG1=XICFG1&(~INT0IS2);SFRPI=0
#define PORT_SetINT0_P10()						XICFG=XICFG&(~(INT0IS0|INT0IS1));SFRPI =XICFG1_Page;XICFG1=XICFG1|INT0IS2;SFRPI=0
#define PORT_SetINT0_P14()						XICFG=(XICFG&(~INT0IS1))|INT0IS0;SFRPI =XICFG1_Page;XICFG1=XICFG1|INT0IS2;SFRPI=0
#define PORT_SetINT0_P17()						XICFG=(XICFG&(~INT0IS0))|INT0IS1;SFRPI =XICFG1_Page;XICFG1=XICFG1|INT0IS2;SFRPI=0
#define PORT_SetINT0_P05()						XICFG=XICFG|(INT0IS0|INT0IS1);SFRPI =XICFG1_Page;XICFG1=XICFG1|INT0IS2;SFRPI=0

#define PORT_SetINT1_P33()						XICFG=XICFG&(~(INT1IS0|INT1IS1));SFRPI =XICFG1_Page;XICFG1=XICFG1&(~INT1IS2);SFRPI=0
#define PORT_SetINT1_P31()						XICFG=(XICFG&(~INT1IS1))|INT1IS0;SFRPI =XICFG1_Page;XICFG1=XICFG1&(~INT1IS2);SFRPI=0
#define PORT_SetINT1_P35()						XICFG=(XICFG&(~INT1IS0))|INT1IS1;SFRPI =XICFG1_Page;XICFG1=XICFG1&(~INT1IS2);SFRPI=0
#define PORT_SetINT1_P41()						XICFG=XICFG|(INT1IS0|INT1IS1);SFRPI =XICFG1_Page;XICFG1=XICFG1&(~INT1IS2);SFRPI=0
#define PORT_SetINT1_P45()						XICFG=XICFG&(~(INT1IS0|INT1IS1));SFRPI =XICFG1_Page;XICFG1=XICFG1|INT1IS2;SFRPI=0
#define PORT_SetINT1_P15()						XICFG=(XICFG&(~INT1IS1))|INT1IS0;SFRPI =XICFG1_Page;XICFG1=XICFG1|INT1IS2;SFRPI=0
#define PORT_SetINT1_P10()						XICFG=(XICFG&(~INT1IS0))|INT1IS1;SFRPI =XICFG1_Page;XICFG1=XICFG1|INT1IS2;SFRPI=0
#define PORT_SetINT1_P07()						XICFG=XICFG|(INT1IS0|INT1IS1);SFRPI =XICFG1_Page;XICFG1=XICFG1|INT1IS2;SFRPI=0

#define PORT_SetINT2_P44()						SFRPI=XICFG1_Page;XICFG1=XICFG1&(~(INT2IS0|INT2IS1));SFRPI=0
#define PORT_SetINT2_P30()						SFRPI=XICFG1_Page;XICFG1=(XICFG1&(~INT2IS1))|INT2IS0;SFRPI=0
#define PORT_SetINT2_P11()						SFRPI=XICFG1_Page;XICFG1=(XICFG1&(~INT2IS0))|INT2IS1;SFRPI=0
#define PORT_SetINT2_P16()						SFRPI=XICFG1_Page;XICFG1=XICFG1|(INT2IS0|INT2IS1);SFRPI=0
#define PORT_SetINT2_P14()						SFRPI=XICFG1_Page;XICFG1=XICFG1&(~(INT2IS0|INT2IS1));SFRPI=2;XICFG2=XICFG2|INT2IS2;SFRPI=0
#define PORT_SetINT2_P60()						SFRPI=XICFG1_Page;XICFG1=(XICFG1&(~INT2IS1))|INT2IS0;SFRPI=2;XICFG2=XICFG2|INT2IS2;SFRPI=0
#define PORT_SetINT2_P01()						SFRPI=XICFG1_Page;XICFG1=(XICFG1&(~INT2IS0))|INT2IS1;SFRPI=2;XICFG2=XICFG2|INT2IS2;SFRPI=0
#define PORT_SetINT2_P61()						SFRPI=XICFG1_Page;XICFG1=XICFG1|(INT2IS0|INT2IS1);SFRPI=2;XICFG2=XICFG2|INT2IS2;SFRPI=0

#define PORT_SetINT3_P45()						SFRPI=XICFG2_Page;XICFG2=XICFG2&(~(INT3IS0|INT3IS1|INT3IS2));SFRPI=0
#define PORT_SetINT3_P22()						SFRPI=XICFG2_Page;XICFG2=(XICFG2&(~(INT3IS0|INT3IS1|INT3IS2)))|(INT3IS0);SFRPI=0
#define PORT_SetINT3_P15()						SFRPI=XICFG2_Page;XICFG2=(XICFG2&(~(INT3IS0|INT3IS1|INT3IS2)))|(INT3IS1);SFRPI=0
#define PORT_SetINT3_P16()						SFRPI=XICFG2_Page;XICFG2=(XICFG2&(~(INT3IS0|INT3IS1|INT3IS2)))|(INT3IS0|INT3IS1);SFRPI=0
#define PORT_SetINT3_P02()						SFRPI=XICFG2_Page;XICFG2=(XICFG2&(~(INT3IS0|INT3IS1|INT3IS2)))|(INT3IS2);SFRPI=0
#define PORT_SetINT3_P61()						SFRPI=XICFG2_Page;XICFG2=(XICFG2&(~(INT3IS0|INT3IS1|INT3IS2)))|(INT3IS0|INT3IS2);SFRPI=0
#define PORT_SetINT3_P12()						SFRPI=XICFG2_Page;XICFG2=(XICFG2&(~(INT3IS0|INT3IS1|INT3IS2)))|(INT3IS1|INT3IS2);SFRPI=0
#define PORT_SetINT3_P60()						SFRPI=XICFG2_Page;XICFG2=(XICFG2&(~(INT3IS0|INT3IS1|INT3IS2)))|(INT3IS0|INT3IS1|INT3IS2);SFRPI=0

/*
*************************************************************************************
*/

/*
//*************************************************************************************
//*  TWI0
//*
//*************************************************************************************
*/
// 清TWI0
#define TWI0_Clear()				SICON=0
// 开启或关闭TWI0
#define TWI0_Disable()				SICON=SICON&(~ENSI)
#define TWI0_Enable()				SICON=SICON|(ENSI)

// 选择TWI0 的传送速度  主机最高1MHz, 从机同步任何主机的频率,最高支持400KHz
#define TWI0_CLK_SYSCLK_DIV_32	0
#define TWI0_CLK_SYSCLK_DIV_48	1
#define TWI0_CLK_SYSCLK_DIV_60	2
#define TWI0_CLK_SYSCLK_DIV_64	3
#define TWI0_CLK_SYSCLK_DIV_128	4
#define TWI0_CLK_SYSCLK_DIV_256	5
#define TWI0_CLK_S0TOF_DIV_16	6
#define TWI0_CLK_T0OF_DIV_16	7
#define TWI0_CLK_SYSCLK_DIV_80	8
#define TWI0_CLK_SYSCLK_DIV_90	9
#define TWI0_CLK_SYSCLK_DIV_120	10
#define TWI0_CLK_SYSCLK_DIV_240	11
#define TWI0_CLK_SYSCLK_DIV_330	12
#define TWI0_CLK_SYSCLK_DIV_480	13
#define TWI0_CLK_SYSCLK_DIV_512	14
#define TWI0_CLK_SYSCLK_DIV_160	15

#define TWI0_SetClock(x)			SICON=(SICON&B01111100)|((x&0x03)|((x<<5)&B10000000));SFRPI=SICR1_Page;SICR1=(SICR1&B11111110)|((x>>3)&BIT0);SFRPI=0

#define TWI0_SetSlaveAddr(x)		SIADR=x			// 设置从机地址
#define TWI0_SetSlaveAddr2nd(x)		SFRPI=SIA2_Page;SIA2=x;SFRPI=0			// 设置第二从机地址
#define TWI0_SetSlaveAddr2nd_Disable()		SFRPI=SIA2_Page;SIA2=SIA2&(~(A2E));SFRPI=0
#define TWI0_SetSlaveAddr2nd_Enable()		SFRPI=SIA2_Page;SIA2=SIA2|(A2E);SFRPI=0
#define TWI0_SetSlaveAddr2ndMask(x)			SFRPI=SIA2M_Page;SIA2M=x|BIT0;SFRPI=0


#define TWI0_SendACK()				SICON |= AA		// 发送ACK
#define TWI0_SendNOACK()			SICON &= ~AA	// 发送 NO ACK
#define TWI0_SendSTART()			SICON |= STA	// 发送起始位
#define TWI0_ClearSTART()			SICON &= ~STA	// 清除起始标志
#define TWI0_SendSTOP()				SICON |= STO	// 发送停止位，停止标志由硬件清除
#define TWI0_ClearSI()				SICON &= ~SI	// 清楚TWI中断标志

// 选择TWI0 所用的IO口 SCL/SDA
#define TWI0_SetTWI0SCLTWI0SDA_P40P41()			AUXR3=(AUXR3&(~(TWIPS1|TWIPS0)))
#define TWI0_SetTWI0SCLTWI0SDA_P60P61()			AUXR3=(AUXR3&(~(TWIPS1|TWIPS0)))|TWIPS0
#define TWI0_SetTWI0SCLTWI0SDA_P31P30()			AUXR3=(AUXR3&(~(TWIPS1|TWIPS0)))|TWIPS1
#define TWI0_SetTWI0SCLTWI0SDA_P22P24()			AUXR3=(AUXR3|(TWIPS1|TWIPS0))

// 开启或关闭TWI0 DMA模式下预设ACK
#define TWI0_DisPAA()				SFRPI=7;AUXR10=AUXR10&(~PAA);SFRPI=0
#define TWI0_EnPAA()				SFRPI=7;AUXR10=AUXR10|(PAA);SFRPI=0

// 开启或关闭TWI0 STSTA=0xF8产生中断
#define TWI0_DisF8Interrupt()				SFRPI=SICR1_Page;SICR1=SICR1&(~F8IE);SFRPI=0
#define TWI0_EnF8Interrupt()				SFRPI=SICR1_Page;SICR1=SICR1|(F8IE);SFRPI=0

// 设置TWI0 滤波模式
#define TWI0_SetFilter_Fixed()				SFRPI=SICR1_Page;SICR1=SICR1&(~MTSE);SFRPI=0
#define TWI0_SetFilter_SYSCLKDiv3()				SFRPI=SICR1_Page;SICR1=SICR1|(MTSE);SFRPI=0

/*
*************************************************************************************
*/

/*
//*************************************************************************************
//*  TWI1
//*
//*************************************************************************************
*/
// 清TWI1
#define TWI1_Clear()				SFRPI=SI1CON_Page;SI1CON=0;SFRPI=0
// 开启或关闭TWI1
#define TWI1_Disable()				SFRPI=SI1CON_Page;SI1CON=SI1CON&(~ENSI1);SFRPI=0
#define TWI1_Enable()				SFRPI=SI1CON_Page;SI1CON=SI1CON|(ENSI1);SFRPI=0

// 选择TWI1 的传送速度  主机最高1MHz, 从机同步任何主机的频率,最高支持400KHz
#define TWI1_CLK_SYSCLK_DIV_32	0
#define TWI1_CLK_SYSCLK_DIV_48	1
#define TWI1_CLK_SYSCLK_DIV_60	2
#define TWI1_CLK_SYSCLK_DIV_64	3
#define TWI1_CLK_SYSCLK_DIV_128	4
#define TWI1_CLK_SYSCLK_DIV_256	5
#define TWI1_CLK_S0TOF_DIV_16	6
#define TWI1_CLK_T0OF_DIV_16	7
#define TWI1_CLK_SYSCLK_DIV_80	8
#define TWI1_CLK_SYSCLK_DIV_90	9
#define TWI1_CLK_SYSCLK_DIV_120	10
#define TWI1_CLK_SYSCLK_DIV_240	11
#define TWI1_CLK_SYSCLK_DIV_330	12
#define TWI1_CLK_SYSCLK_DIV_480	13
#define TWI1_CLK_SYSCLK_DIV_512	14
#define TWI1_CLK_SYSCLK_DIV_160	15

#define TWI1_SetClock(x)					SFRPI=SI1CON_Page;SI1CON=(SI1CON&B01111100)|((x&0x03)|((x<<5)&B10000000));SFRPI=SI1CR1_Page;SI1CR1=(SI1CR1&B11111110)|((x>>3)&BIT0);SFRPI=0

#define TWI1_SetSlaveAddr(x)				SFRPI=SI1ADR_Page;SI1ADR=x;SFRPI=0			// 设置从机地址
#define TWI1_SetSlaveAddr2nd(x)				SFRPI=SIA2_Page;SI1A2=x;SFRPI=0				// 设置第二从机地址
#define TWI1_SetSlaveAddr2nd_Disable()		SFRPI=SIA2_Page;SI1A2=SI1A2&(~(A2E1));SFRPI=0
#define TWI1_SetSlaveAddr2nd_Enable()		SFRPI=SIA2_Page;SI1A2=SI1A2|(A2E1);SFRPI=0
#define TWI1_SetSlaveAddr2ndMask(x)			SFRPI=SIA2M_Page;SI1A2M=x|BIT0;SFRPI=0

#define TWI1_SendACK()						SFRPI=SI1CON_Page;SI1CON |= AA1;SFRPI=0			// 发送ACK
#define TWI1_SendNOACK()					SFRPI=SI1CON_Page;SI1CON &= ~AA1;SFRPI=0		// 发送 NO ACK
#define TWI1_SendSTART()					SFRPI=SI1CON_Page;SI1CON |= STA1;SFRPI=0		// 发送起始位
#define TWI1_ClearSTART()					SFRPI=SI1CON_Page;SI1CON &= ~STA1;SFRPI=0		// 清除起始标志
#define TWI1_SendSTOP()						SFRPI=SI1CON_Page;SI1CON |= STO1;SFRPI=0		// 发送停止位，停止标志由硬件清除
#define TWI1_ClearSI()						SFRPI=SI1CON_Page;SI1CON &= ~SI1;SFRPI=0		// 清楚TWI中断标志


// 选择TWI1 所用的IO口 SCL/SDA
#define TWI1_SetTWI1SCLTWI1SDA_P10P11()			SFRPI=AUXR11_Page;AUXR11=(AUXR11&(~(I2C1PS1|I2C1PS0)));SFRPI=0
#define TWI1_SetTWI1SCLTWI1SDA_P60P61()			SFRPI=AUXR11_Page;AUXR11=(AUXR11&(~(I2C1PS1|I2C1PS0)))|I2C1PS0;SFRPI=0
#define TWI1_SetTWI1SCLTWI1SDA_P30P31()			SFRPI=AUXR11_Page;AUXR11=(AUXR11&(~(I2C1PS1|I2C1PS0)))|I2C1PS1;SFRPI=0
#define TWI1_SetTWI1SCLTWI1SDA_TWI0SCLSDA()		SFRPI=AUXR11_Page;AUXR11=(AUXR11|(I2C1PS1|I2C1PS0));SFRPI=0

// 开启或关闭TWI1 DMA模式下预设ACK
#define TWI1_DisPAA()						SFRPI=8;AUXR11=AUXR11&(~PAA);SFRPI=0
#define TWI1_EnPAA()						SFRPI=8;AUXR11=AUXR11|(PAA);SFRPI=0

// 开启或关闭TWI1 STSTA=0xF8产生中断
#define TWI1_DisF8Interrupt()				SFRPI=SI1CR1_Page;SI1CR1=SI1CR1&(~F8IE1);SFRPI=0
#define TWI1_EnF8Interrupt()				SFRPI=SI1CR1_Page;SI1CR1=SICR1|(F8IE1);SFRPI=0

// 设置TWI1 滤波模式
#define TWI1_SetFilter_Fixed()				SFRPI=SI1CR1_Page;SI1CR1=SI1CR1&(~MTSE1);SFRPI=0
#define TWI1_SetFilter_SYSCLKDiv3()			SFRPI=SI1CR1_Page;SI1CR1=SI1CR1|(MTSE1);SFRPI=0

/*
*************************************************************************************
*/

/*
//*************************************************************************************
//*  UART0
//*
//*************************************************************************************
*/
// UART0 设置UART0工作模式
#define UART0_SetModeShiftReg()					S0CFG=S0CFG|(SMOD3);S0CFG=S0CFG&(~SM30);SM00=0;SM10=0
#define UART0_SetMode8bitUARTVar()				S0CFG=S0CFG|(SMOD3);S0CFG=S0CFG&(~SM30);SM00=0;SM10=1
#define UART0_SetMode9bitUART()					S0CFG=S0CFG|(SMOD3);S0CFG=S0CFG&(~SM30);SM00=1;SM10=0
#define UART0_SetMode9bitUARTVar()				S0CFG=S0CFG|(SMOD3);S0CFG=S0CFG&(~SM30);SM00=1;SM10=1
#define UART0_SetModeSPIMaster()				S0CFG=S0CFG|(SMOD3);S0CFG=S0CFG|(SM30);SM00=0;SM10=0
#define UART0_SetMode9bitUART_S0BRT8BitTimer()	S0CFG=S0CFG|(SMOD3);S0CFG=S0CFG&(~SM30);SM00=1;SM10=0;S0CR1=S0CR1|(S0TCK|S0RCK);S0CFG=S0CFG&(~S0DOR)
#define UART0_SetMode9bitUART_S0BRT16BitTimer()	S0CFG=S0CFG|(SMOD3);S0CFG=S0CFG&(~SM30);SM00=1;SM10=0;S0CR1=S0CR1|(S0TCK|S0RCK);S0CFG=S0CFG|(S0DOR)
#define UART0_SetModeARGB()						S0CFG=S0CFG|(SMOD3);S0CFG=S0CFG&(~SM30);SM00=0;SM10=0;S0CR1=S0CR1|(S0TCK|S0RCK)

// UART0 开启/关闭自动地址识别功能
#define UART0_EnAutoAddressRecognition()	SM20=1
#define UART0_DisAutoAddressRecognition()	SM20=0

// UART0 开启/关闭接收数据功能
#define UART0_EnReception()					REN0=1
#define UART0_DisReception()				REN0=0

// UART0 设置数据位序(MSB:高位在前,LSB:低位在前)
#define UART0_SetDataMSB()					S0CFG=S0CFG&(~S0DOR)
#define UART0_SetDataLSB()					S0CFG=S0CFG|(S0DOR)

// UART0 开启/关闭响应发送完成中断TI0
#define UART0_EnTI0toS0Interrupt()			S0CFG=S0CFG&(~BTI)
#define UART0_DisTI0toS0Interrupt()			S0CFG=S0CFG|(BTI)

// UART0 开启/关闭系统标志中断响应发送完成中断TI0
#define UART0_EnTI0toSysFlagInterrupt()		S0CFG=S0CFG|(UTIE)
#define UART0_DisTI0toSysFlagInterrupt()	S0CFG=S0CFG&(~UTIE)

// UART0 设置SFR 0xB9地址是访问SADEN还是S0CR1
#define UART0_SetAccess0xB9_SADEN()				S0CFG=S0CFG&(~SMOD3)
#define UART0_SetAccess0xB9_S0CR1()				S0CFG=S0CFG|(SMOD3)

// UART0 设置SFR 0xA9地址是访问SADDR还是EDC45
#define UART0_SetAccess0xA9_SADDR()				SFRPI=AUXR12_Page;AUXR12=AUXR12&(~GPLC0);SFRPI=0
#define UART0_SetAccess0xA9_EDC45()				SFRPI=AUXR12_Page;AUXR12=AUXR12|(GPLC0);SFRPI=0

// UART0 设置从机地址
#define UART0_SetSlaveAddr(x)				SADDR=x

// UART0 设置从机地址掩码
#define UART0_SetSlaveAddrMask(x)			S0CFG=S0CFG&(~SMOD3);SADEN=x;S0CFG=S0CFG|(SMOD3)

// UART0 设置波特率加倍设置
#define UART0_SetT1BaudRateX1()				PCON0=PCON0&(~SMOD1);S0CFG=S0CFG&(~SMOD2)
#define UART0_SetT1BaudRateX2()				PCON0=PCON0|(SMOD1);S0CFG=S0CFG&(~SMOD2)
#define UART0_SetT1BaudRateX4()				PCON0=PCON0&(~SMOD1);S0CFG=S0CFG|(SMOD2)

#define UART0_SetT2BaudRateX1()				S0CFG=S0CFG&(~SMOD2)
#define UART0_SetT2BaudRateX2()				PCON0=PCON0&(~SMOD1);S0CFG=S0CFG|(SMOD2)

#define UART0_SetS0BRGBaudRateX1()			PCON0=PCON0&(~SMOD1);S0CFG=S0CFG&(~SMOD2)
#define UART0_SetS0BRGBaudRateX2()			PCON0=PCON0|(SMOD1);S0CFG=S0CFG&(~SMOD2)
#define UART0_SetS0BRGBaudRateX4()			PCON0=PCON0&(~SMOD1);S0CFG=S0CFG|(SMOD2)

#define UART0_SetS1BRGBaudRateX1()			PCON0=PCON0&(~SMOD1);S0CFG=S0CFG&(~SMOD2)
#define UART0_SetS1BRGBaudRateX2()			PCON0=PCON0|(SMOD1);S0CFG=S0CFG&(~SMOD2)
#define UART0_SetS1BRGBaudRateX4()			PCON0=PCON0&(~SMOD1);S0CFG=S0CFG|(SMOD2)

// UART0 设置波特率来源
#define UART0_SetBRGFromT1()				S0CR1=S0CR1&(~(S0TCK|S0RCK));SFRPI=1;T2MOD1=T2MOD1&(~TL2IS);SFRPI=0;RCLK_TF2L=0;TCLK_TL2IE=0;S0CFG=S0CFG&(~URTS)
#define UART0_SetBRGFromT2()				S0CR1=S0CR1&(~(S0TCK|S0RCK));SFRPI=1;T2MOD1=T2MOD1&(~TL2IS);SFRPI=0;RCLK_TF2L=1;TCLK_TL2IE=1
#define UART0_SetBRGFromS1BRG()				S0CR1=S0CR1&(~(S0TCK|S0RCK));SFRPI=1;T2MOD1=T2MOD1&(~TL2IS);SFRPI=0;RCLK_TF2L=0;TCLK_TL2IE=0;S0CFG=S0CFG|(URTS)
#define UART0_SetBRGFromS0BRG()				S0CR1=S0CR1|(S0TCK|S0RCK)
#define UART0_SetBRG_TXDFromS0BRG()			S0CR1=S0CR1|S0TCK
#define UART0_SetBRG_RXDFromS0BRG()			S0CR1=S0CR1|S0RCK

// UART0 设置IO口
#define UART0_SetRxTxP30P31()				SFRPI=AUXR10_Page;AUXR10=AUXR10&(~S0PS1);SFRPI=0;	AUXR3=AUXR3&(~S0PS0)
#define UART0_SetRxTxP44P45()				SFRPI=AUXR10_Page;AUXR10=AUXR10&(~S0PS1);SFRPI=0;	AUXR3=AUXR3|(S0PS0)
#define UART0_SetRxTxP31P30()				SFRPI=AUXR10_Page;AUXR10=AUXR10|(S0PS1);SFRPI=0;	AUXR3=AUXR3&(~S0PS0)
#define UART0_SetRxTxP17P22()				SFRPI=AUXR10_Page;AUXR10=AUXR10|(S0PS1);SFRPI=0;	AUXR3=AUXR3|(S0PS0)

// UART0 开启/关闭S0BRG波特率发生器
#define UART0_EnS0BRG()						S0CR1=S0CR1|S0TR
#define UART0_DisS0BRG()					S0CR1=S0CR1&(~S0TR)

// UART0 设置S0BRG时钟源
#define UART0_SetS0BRGSelSYSCLK()			S0CR1=S0CR1|(S0TX12)
#define UART0_SetS0BRGSelSYSCLKdiv12()		S0CR1=S0CR1&(~S0TX12)

// UART0 设置S0BRG Value
#define UART0_SetS0BRGValue(x)				S0BRT=x;S0BRC=x

// UART0 开启/关闭S0CKO 输出
#define UART0_EnS0CKO()						S0CR1=S0CR1|S0CKOE
#define UART0_DisS0CKO()					S0CR1=S0CR1&(~S0CKOE)

// UART0 开启/关闭自动重发
#define UART0_EnAutoRepeatTrans()			S0CR1=S0CR1|ARTE
#define UART0_DisAutoRepeatTrans()			S0CR1=S0CR1&(~ARTE)

// UART0 选择S0CKO 输出引脚
#define UART0_SetS0CKOP47()					SFRPI=AUXR6_Page;AUXR6=AUXR6&(~S0COPS);SFRPI=0
#define UART0_SetS0CKOP44()					SFRPI=AUXR6_Page;AUXR6=AUXR6|S0COPS;SFRPI=0

// UART0 设置UART0 SPI模式
#define UART0_SetSPIMaster_CPOL_0_CPHA_0()	SM20=1;TB80=1
#define UART0_SetSPIMaster_CPOL_0_CPHA_1()	SM20=1;TB80=0
#define UART0_SetSPIMaster_CPOL_1_CPHA_0()	SM20=0;TB80=1
#define UART0_SetSPIMaster_CPOL_1_CPHA_1()	SM20=0;TB80=0

// UART0 设置UART0 SPI Clock
#define UART0_SetSPIMasterClock_SYSCLKDiv12()	S0CR1=S0CR1&(~(S0TCK|S0RCK));PCON0=PCON0&(~SMOD1)
#define UART0_SetSPIMasterClock_SYSCLKDiv4()	S0CR1=S0CR1&(~(S0TCK|S0RCK));PCON0=PCON0|(SMOD1)
#define UART0_SetSPIMasterClock_S0BRG()			S0CR1=(S0CR1&(~(S0TCK|S0RCK)))|S0TCK

// UART 设置UART0/UART1 SPI模式下MISO所用的IO口
#define UART_SetS0MIS1MI_P16P10()			SFRPI=AUXR6_Page;AUXR6=AUXR6&(~(SnMIPS));SFRPI=0
#define UART_SetS0MIS1MI_P33P35()			SFRPI=AUXR6_Page;AUXR6=AUXR6|((SnMIPS));SFRPI=0

// UART0 设置UART0 ARGB Duty
#define UART0_SetARGBDuty_1_4()			S0DTY1=0
#define UART0_SetARGBDuty_1_3()			S0DTY1=1

// UAR0T 设置UART0 ARGB TI0中断
#define UART0_SetARGBTI0Interrupt_Enable()			S0GFIE=0
#define UART0_SetARGBTI0Interrupt_Disable()			S0GFIE=1

// UART0 设置UART0 ARGB Reset time
#define UART0_SetARGBResetTime_BaudRate_x8x6()			S0IDT11=1;S0IDT01=0
#define UART0_SetARGBResetTime_BaudRate_x8x20()			S0IDT11=0;S0IDT01=1
#define UART0_SetARGBResetTime_BaudRate_x8x26()			S0IDT11=0;S0IDT01=0
#define UART0_SetARGBResetTime_BaudRate_x8x32()			S0IDT11=1;S0IDT01=1

/*
*************************************************************************************
*/

/*
//*************************************************************************************
//*  UART1
//*
//*************************************************************************************
*/
// UART1 设置UART1工作模式
#define UART1_SetModeShiftReg()				SFRPI=S1CFG_Page;S1CFG=(S1CFG&(~(S1TME|SM31)))|(S1MOD3);SM01=0;SM11=0;SFRPI=0
#define UART1_SetMode8bitUARTVar()			SFRPI=S1CFG_Page;S1CFG=(S1CFG&(~(S1TME|SM31)))|(S1MOD3);SM01=0;SM11=1;SFRPI=0
#define UART1_SetMode9bitUART()				SFRPI=S1CFG_Page;S1CFG=(S1CFG&(~(S1TME|SM31)))|(S1MOD3);SM01=1;SM11=0;SFRPI=0
#define UART1_SetMode9bitUARTVar()			SFRPI=S1CFG_Page;S1CFG=(S1CFG&(~(S1TME|SM31)))|(S1MOD3);SM01=1;SM11=1;SFRPI=0
#define UART1_SetModeSPIMaster()			SFRPI=S1CFG_Page;S1CFG=(S1CFG&(~(S1TME|SM31)))|(SM31|(S1MOD3));SM01=0;SM11=0;SFRPI=0
#define UART1_SetModeBMCENDec()				SFRPI=S1CFG_Page;S1CFG=(S1CFG&(~(S1TME|SM31)))|(SM31|(S1MOD3));SM01=1;SM11=0;SFRPI=0
#define UART1_SetMode8BitTimer()			SFRPI=S1CFG_Page;S1CFG=(S1CFG&(~(S1TME|SM31)))|(S1TME|(S1MOD3));SM01=0;SM11=0;SFRPI=0
#define UART1_SetModeARGB()					SFRPI=S1CFG_Page;S1CFG=(S1CFG&(~(S1TME|SM31)))|(S1TME|(S1MOD3));SM01=0;SM11=1;SFRPI=0


// UART1 开启/关闭接收数据功能
#define UART1_EnReception()					SFRPI=S1CON_Page;REN1=1;SFRPI=0
#define UART1_DisReception()				SFRPI=S1CON_Page;REN1=0;SFRPI=0

// UART1 设置数据位序(MSB:高位在前,LSB:低位在前)
#define UART1_SetDataMSB()					SFRPI=S1CFG_Page;S1CFG=S1CFG&(~S1DOR);SFRPI=0
#define UART1_SetDataLSB()					SFRPI=S1CFG_Page;S1CFG=S1CFG|(S1DOR);SFRPI=0

// UART1 设置波特率加倍设置
#define UART1_SetBaudRateX1()				SFRPI=S1CFG_Page;S1CFG=S1CFG&(~S1MOD1);SFRPI=0
#define UART1_SetBaudRateX2()				SFRPI=S1CFG_Page;S1CFG=S1CFG|(S1MOD1);SFRPI=0

// UART1 开启/关闭波特率发生器
#define UART1_EnS1BRG()						SFRPI=S1CFG_Page;S1CFG=S1CFG|(S1TR);SFRPI=0
#define UART1_DisS1BRG()					SFRPI=S1CFG_Page;S1CFG=S1CFG&(~S1TR);SFRPI=0

// UART1 设置S1BRG时钟源
#define UART1_SetS1BRGSelSYSCLK()			SFRPI=S1CFG_Page;S1CFG=S1CFG|(S1TX12);SFRPI=0
#define UART1_SetS1BRGSelSYSCLKdiv12()		SFRPI=S1CFG_Page;S1CFG=S1CFG&(~S1TX12);SFRPI=0

// UART1 设置S1BRG Value
#define UART1_SetS1BRGValue(x)				SFRPI=1;S1CFG=S1CFG&(~S1MOD3);S1BRT=x;S1BRC=x;S1CFG=S1CFG|(S1MOD3);SFRPI=0

// UART1 开启/关闭S1CKO 输出
#define UART1_EnS1CKO()						SFRPI=S1CFG_Page;S1CFG=S1CFG|S1CKOE;SFRPI=0
#define UART1_DisS1CKO()					SFRPI=S1CFG_Page;S1CFG=S1CFG&(~S1CKOE);SFRPI=0

// UART1 选择S1CKO 输出引脚
#define UART1_SetS1CKOP45()					SFRPI=AUXR8_Page;AUXR8=AUXR8|S1COPS;SFRPI=0
#define UART1_SetS1CKOP46()					SFRPI=AUXR8_Page;AUXR8=AUXR8&(~S1COPS);SFRPI=0

// UART1 选择 所用的IO口
#define UART1_SetRXD1TXD1_P12P13()			SFRPI=AUXR9_Page;AUXR9=AUXR9&(~(S1PS1|S1PS0));SFRPI=0
#define UART1_SetRXD1TXD1_P60P61()			SFRPI=AUXR9_Page;AUXR9=(AUXR9&(~(S1PS1|S1PS0)))|S1PS0;SFRPI=0
#define UART1_SetRXD1TXD1_P10P11()			SFRPI=AUXR9_Page;AUXR9=(AUXR9&(~(S1PS1|S1PS0)))|S1PS1;SFRPI=0
#define UART1_SetRXD1TXD1_P34P35()			SFRPI=AUXR9_Page;AUXR9=AUXR9|(S1PS1|S1PS0);SFRPI=0

// UART1 设置 SPI模式
#define UART1_SetSPIMaster_CPOL_0_CPHA_0()	SFRPI=S1CON_Page;SM21=1;TB81=1;SFRPI=0
#define UART1_SetSPIMaster_CPOL_0_CPHA_1()	SFRPI=S1CON_Page;SM21=1;TB81=0;SFRPI=0
#define UART1_SetSPIMaster_CPOL_1_CPHA_0()	SFRPI=S1CON_Page;SM21=0;TB81=1;SFRPI=0
#define UART1_SetSPIMaster_CPOL_1_CPHA_1()	SFRPI=S1CON_Page;SM21=0;TB81=0;SFRPI=0

// UART1 设置 SPI Clock
#define UART1_SetSPIMasterClock_SYSCLKDiv12()	SFRPI=S1CFG_Page;S1CFG=S1CFG&(~S1MOD1);SFRPI=0
#define UART1_SetSPIMasterClock_SYSCLKDiv4()	SFRPI=S1CFG_Page;S1CFG=S1CFG|S1MOD1;SFRPI=0


// UART1 设置 ARGB Duty
#define UART1_SetARGBDuty_1_4()						SFRPI=S1AGCR_Page;S1DTY1=0;SFRPI=0
#define UART1_SetARGBDuty_1_3()						SFRPI=S1AGCR_Page;S1DTY1=1;SFRPI=0

// UART1 设置 ARGB TI0中断
#define UART1_SetARGBTI1Interrupt_Enable()			SFRPI=S1AGCR_Page;S1GFIE=0;SFRPI=0
#define UART1_SetARGBTI1Interrupt_Disable()			SFRPI=S1AGCR_Page;S1GFIE=1;SFRPI=0

// UART1 设置 ARGB Reset time
#define UART1_SetARGBResetTime_BaudRate_x8x26()			SFRPI=S1AGCR_Page;S1IDT11=0;S1IDT01=0;SFRPI=0
#define UART1_SetARGBResetTime_BaudRate_x8x20()			SFRPI=S1AGCR_Page;S1IDT11=0;S1IDT01=1;SFRPI=0
#define UART1_SetARGBResetTime_BaudRate_x8x6()			SFRPI=S1AGCR_Page;S1IDT11=1;S1IDT01=0;SFRPI=0
#define UART1_SetARGBResetTime_BaudRate_x8x32()			SFRPI=S1AGCR_Page;S1IDT11=1;S1IDT01=1;SFRPI=0

// UART1 设置PDTXOE
#define UART1_SetPDTXOEOutput_Low()					SFRPI=S1CFG6_Page;S1CFG6=S1CFG6&(~PDOEC1);SFRPI=0
#define UART1_SetPDTXOEOutput_High()				SFRPI=S1CFG6_Page;S1CFG6=S1CFG6|(PDOEC1);SFRPI=0

// UART1 使能/禁止PDTXOE 输出
#define UART1_SetPDTXOEOutput_Disable()				SFRPI=S1CFG6_Page;S1CFG6=S1CFG6&(~PDOE1);SFRPI=0
#define UART1_SetPDTXOEOutput_Enable()				SFRPI=S1CFG6_Page;S1CFG6=S1CFG6|(PDOE1);SFRPI=0

// UART1 设置USB PD BMC
#define UART1_SetPDBMC_Disable()					SFRPI=S1CFG6_Page;S1CFG6=S1CFG6&(~M6PDE1);SFRPI=0
#define UART1_SetPDBMC_Enable()						SFRPI=S1CFG6_Page;S1CFG6=S1CFG6|(M6PDE1);SFRPI=0

// UART1 设置SFR 0x9B地址是访问SCBRT还是S1CR1
#define UART1_SetAccess_S1BRC()						SFRPI=S1CFG_Page;S1CFG=S1CFG&(~S1MOD3);SFRPI=0
#define UART1_SetAccess_S1CR1()						SFRPI=S1CFG_Page;S1CFG=S1CFG|(S1MOD3);SFRPI=0

// UART1 设置SOPWEC
#define UART1_SetSOPWEC_Disable()					SFRPI=S1CR1_Page;S1CR1=S1CR1&(~M6PDE1);SFRPI=0
#define UART1_SetSOPWEC_Enable()					SFRPI=S1CR1_Page;S1CR1=S1CR1|(M6PDE1);SFRPI=0

// UART1 触发TXD1输出信号
#define UART1_ToggleTXD1Output()					SFRPI=S1CR1_Page;S1CR1=S1CR1|(TOTXD1);SFRPI=0

// UART1 设置PD模式下RI1
#define UART1_SetRI1inPD_Disable()					SFRPI=S1CR1_Page;S1CR1=S1CR1&(~RMRI1);SFRPI=0
#define UART1_SetRI1inPD_Enable()					SFRPI=S1CR1_Page;S1CR1=S1CR1|(RMRI1);SFRPI=0

// UART1 外部输入滤波控制
#define UART1_SetEXTFLT_Disable()					SFRPI=S1CR1_Page;S1CR1=S1CR1&(~EXTFLT);SFRPI=0
#define UART1_SetEXTFLT_Enable()					SFRPI=S1CR1_Page;S1CR1=S1CR1|(EXTFLT);SFRPI=0

// UART1 TXD反向
#define UART1_SetTXD1Invert_Disable()				SFRPI=S1CR1_Page;S1CR1=S1CR1&(~TXINV1);SFRPI=0
#define UART1_SetTXD1Invert_Enable()				SFRPI=S1CR1_Page;S1CR1=S1CR1|(TXINV1);SFRPI=0

// UART1 RXD反向
#define UART1_SetRXD1Invert_Disable()				SFRPI=S1CR1_Page;S1CR1=S1CR1&(~RXINV1);SFRPI=0
#define UART1_SetRXD1Invert_Enable()				SFRPI=S1CR1_Page;S1CR1=S1CR1|(RXINV1);SFRPI=0

// UART1 设置PDTXOE引脚
#define UART1_SetPDTXOE_P15()						SFRPI=AUXR12_Page;AUXR11=(AUXR11&(~(PDOES1|PDOES0)));SFRPI=0
#define UART1_SetPDTXOE_P33()						SFRPI=AUXR12_Page;AUXR11=(AUXR11&(~(PDOES1|PDOES0)))|PDOES0;SFRPI=0
#define UART1_SetPDTXOE_P61()						SFRPI=AUXR12_Page;AUXR11=(AUXR11&(~(PDOES1|PDOES0)))|PDOES1;SFRPI=0
#define UART1_SetPDTXOE_P32()						SFRPI=AUXR12_Page;AUXR11=(AUXR11|(PDOES1|PDOES0));SFRPI=0


/*
//*************************************************************************************
//*  ADC
//*
//*************************************************************************************
*/
#define ADC_AIN0 0x01
#define ADC_AIN1 0x02
#define ADC_AIN2 0x04
#define ADC_AIN3 0x08
#define ADC_AIN4 0x10
#define ADC_AIN5 0x20
#define ADC_AIN6 0x40
#define ADC_AIN7 0x80

// 开启或关闭ADC
#define ADC_Disable()						ADCON0=ADCON0&(~ADCEN)
#define ADC_Enable()						ADCON0=ADCON0|(ADCEN)

// 开启或关闭ADC
#define ADC_SoftStart()						ADCON0=ADCON0|(ADCS)

// 设置ADC的转换时钟源
#define ADC_SetClock_SYSCLK()				ADCFG0=ADCFG0&(~(ADCKS0|ADCKS1|ADCKS2))
#define ADC_SetClock_SYSCLKDiv2()			ADCFG0=(ADCFG0&(~(ADCKS0|ADCKS1|ADCKS2)))|(ADCKS0)
#define ADC_SetClock_SYSCLKDiv4()			ADCFG0=(ADCFG0&(~(ADCKS0|ADCKS1|ADCKS2)))|(ADCKS1)
#define ADC_SetClock_SYSCLKDiv8()			ADCFG0=(ADCFG0&(~(ADCKS0|ADCKS1|ADCKS2)))|(ADCKS0|ADCKS1)
#define ADC_SetClock_SYSCLKDiv16()			ADCFG0=(ADCFG0&(~(ADCKS0|ADCKS1|ADCKS2)))|(ADCKS2)
#define ADC_SetClock_SYSCLKDiv32()			ADCFG0=(ADCFG0&(~(ADCKS0|ADCKS1|ADCKS2)))|(ADCKS0|ADCKS2)
#define ADC_SetClock_S0TOFDiv2()			ADCFG0=(ADCFG0&(~(ADCKS0|ADCKS1|ADCKS2)))|(ADCKS1|ADCKS2)
#define ADC_SetClock_T2OFDiv2()				ADCFG0=ADCFG0|(ADCKS0|ADCKS1|ADCKS2)

// 设置ADC的转换通道
#define ADC_SetChannel_AIN0()				ADCFG0=ADCFG0&(~ACHS);ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))
#define ADC_SetChannel_AIN1()				ADCFG0=ADCFG0&(~ACHS);ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))|(CHS0)
#define ADC_SetChannel_AIN2()				ADCFG0=ADCFG0&(~ACHS);ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))|(CHS1)
#define ADC_SetChannel_AIN3()				ADCFG0=ADCFG0&(~ACHS);ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))|(CHS1|CHS0)
#define ADC_SetChannel_AIN4()				ADCFG0=ADCFG0&(~ACHS);ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))|(CHS2)
#define ADC_SetChannel_AIN5()				ADCFG0=ADCFG0&(~ACHS);ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))|(CHS2|CHS0)
#define ADC_SetChannel_AIN6()				ADCFG0=ADCFG0&(~ACHS);ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))|(CHS2|CHS1)
#define ADC_SetChannel_AIN7()				ADCFG0=ADCFG0&(~ACHS);ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))|(CHS2|CHS1|CHS0)

#define ADC_SetChannel_OP0O()				ADCFG0=ADCFG0|(ACHS);ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))
#define ADC_SetChannel_AVSS()				ADCFG0=ADCFG0|(ACHS);ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))|(CHS0)
#define ADC_SetChannel_OP1O()				ADCFG0=ADCFG0|(ACHS);ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))|(CHS1)
#define ADC_SetChannel_VDD_Div4()			ADCFG0=ADCFG0|(ACHS);ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))|(CHS1|CHS0)
#define ADC_SetChannel_IVR24()				ADCFG0=ADCFG0|(ACHS);ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))|(CHS2)

#define ADC_SetInput_PGDO()					SFRPI=ADCFG4_Page;ADCFG4=ADCFG4|ADMINS;SFRPI=0
#define ADC_SetInput_AIN()					SFRPI=ADCFG4_Page;ADCFG4=ADCFG4&(~ADMINS);SFRPI=0

// 设置ADC的转换模式
#define ADC_SetMode_SetADCS()				SFRPI=ADCFG4_Page;ADCFG4=(ADCFG4&(~(ADTM3|ADTM2)));SFRPI=0;ADCFG0=ADCFG0&(~(ADTM0|ADTM1))
#define ADC_SetMode_T0Overflow()			SFRPI=ADCFG4_Page;ADCFG4=(ADCFG4&(~(ADTM3|ADTM2)));SFRPI=0;ADCFG0=(ADCFG0&(~(ADTM0|ADTM1)))|(ADTM0)
#define ADC_SetMode_FreeRunning()			SFRPI=ADCFG4_Page;ADCFG4=(ADCFG4&(~(ADTM3|ADTM2)));SFRPI=0;ADCFG0=(ADCFG0&(~(ADTM0|ADTM1)))|(ADTM1)
#define ADC_SetMode_S0BRGOverflow()			SFRPI=ADCFG4_Page;ADCFG4=(ADCFG4&(~(ADTM3|ADTM2)));SFRPI=0;ADCFG0=ADCFG0|(ADTM0|ADTM1)
#define ADC_SetMode_KBIET()					SFRPI=ADCFG4_Page;ADCFG4=(ADCFG4&(~(ADTM3|ADTM2)))|(ADTM2);SFRPI=0;ADCFG0=ADCFG0&(~(ADTM0|ADTM1))
#define ADC_SetMode_INT1ET()				SFRPI=ADCFG4_Page;ADCFG4=(ADCFG4&(~(ADTM3|ADTM2)))|(ADTM2);SFRPI=0;ADCFG0=(ADCFG0&(~(ADTM0|ADTM1)))|(ADTM0)
#define ADC_SetMode_INT2ET()				SFRPI=ADCFG4_Page;ADCFG4=(ADCFG4&(~(ADTM3|ADTM2)))|(ADTM2);SFRPI=0;ADCFG0=(ADCFG0&(~(ADTM0|ADTM1)))|(ADTM1)
#define ADC_SetMode_INT3ET()				SFRPI=ADCFG4_Page;ADCFG4=(ADCFG4&(~(ADTM3|ADTM2)))|(ADTM2);SFRPI=0;ADCFG0=(ADCFG0&(~(ADTM0|ADTM1)))|(ADTM1|ADTM0)
#define ADC_SetMode_T2EXES()				SFRPI=ADCFG4_Page;ADCFG4=(ADCFG4&(~(ADTM3|ADTM2)))|(ADTM3);SFRPI=0;ADCFG0=ADCFG0&(~(ADTM0|ADTM1))
#define ADC_SetMode_AC0ES()					SFRPI=ADCFG4_Page;ADCFG4=(ADCFG4&(~(ADTM3|ADTM2)))|(ADTM3);SFRPI=0;ADCFG0=(ADCFG0&(~(ADTM0|ADTM1)))|(ADTM0)
#define ADC_SetMode_T3EXES()				SFRPI=ADCFG4_Page;ADCFG4=(ADCFG4&(~(ADTM3|ADTM2)))|(ADTM3);SFRPI=0;ADCFG0=(ADCFG0&(~(ADTM0|ADTM1)))|(ADTM1)
#define ADC_SetMode_OP0ES()					SFRPI=ADCFG4_Page;ADCFG4=(ADCFG4&(~(ADTM3|ADTM2)))|(ADTM3);SFRPI=0;ADCFG0=(ADCFG0&(~(ADTM0|ADTM1)))|(ADTM1|ADTM0)
#define ADC_SetMode_PTM0Overflow()			SFRPI=ADCFG4_Page;ADCFG4=(ADCFG4&(~(ADTM3|ADTM2)))|(ADTM3|ADTM2);SFRPI=0;ADCFG0=(ADCFG0&(~(ADTM0|ADTM1)))
#define ADC_SetMode_C0CMP5()				SFRPI=ADCFG4_Page;ADCFG4=(ADCFG4&(~(ADTM3|ADTM2)))|(ADTM3|ADTM2);SFRPI=0;ADCFG0=(ADCFG0&(~(ADTM0|ADTM1)))|(ADTM0)
#define ADC_SetMode_C1CMP0orC1CMP1()		SFRPI=ADCFG4_Page;ADCFG4=(ADCFG4&(~(ADTM3|ADTM2)))|(ADTM3|ADTM2);SFRPI=0;ADCFG0=(ADCFG0&(~(ADTM0|ADTM1)))|(ADTM1)
#define ADC_SetMode_OP1ES()					SFRPI=ADCFG4_Page;ADCFG4=(ADCFG4|(ADTM3|ADTM2));SFRPI=0;ADCFG0=(ADCFG0|(ADTM1|ADTM0))

// 设置ADC值左对齐(ADCDH[7:0]ADCDL[7:4])/右对齐(ADCDH[3:0]ADCDL[7:0])
#define ADC_SetLeftJustified()				ADCFG0=ADCFG0&(~ADRJ)
#define ADC_SetRightJustified()				ADCFG0=ADCFG0|(ADRJ)

//	设置DMA的ADC值数据包大小
#define ADC_SetDMADataSize_1Byte()			SFRPI=ADCFG4_Page;ADCFG4=ADCFG4|DBSD;SFRPI=0
#define ADC_SetDMADataSize_2Byte()			SFRPI=ADCFG4_Page;ADCFG4=ADCFG4&(~DBSD);SFRPI=0

// 设置DMA的ADC值数据先后ADCDL先/ADCDH先
#define ADC_SetDMADataADCDLFirst()			SFRPI=ADCFG4_Page;ADCFG4=ADCFG4&(~(DBSD|DOSD));SFRPI=0
#define ADC_SetDMADataADCDHFirst()			SFRPI=ADCFG4_Page;ADCFG4=(ADCFG4&(~(DBSD)))|DOSD;SFRPI=0
#define ADC_SetDMADataADCDHonly()			SFRPI=ADCFG4_Page;ADCFG4=ADCFG4|(DBSD|DOSD);SFRPI=0

// 设置ADC的采样保持时间
#define ADC_SetSampleHoldTime(x)			SFRPI=ADCFG2_Page;ADCFG2=x;SFRPI=0	// SHT=x

// 设置ADC的转换偏移值
#define ADC_SetOffsetAdd(x)					SFRPI=ADCFG1_Page;ADCFG1=(ADCFG1&(~(0x1F)))|(x);SFRPI=0	// ADC值+x (x=0~15)
#define ADC_SetOffsetSub(x)					SFRPI=ADCFG1_Page;ADCFG1=(ADCFG1&(~(0x1F)))|((~x));SFRPI=0	// ADC值-x (x=1~16)

// 设置ADC在范围内还是在范围外置位 ADCWI
#define ADC_SetWindow_WithIn()				SFRPI=ADCFG4_Page;ADCFG4=ADCFG4&(~ADWM0);SFRPI=0
#define ADC_SetWindow_OutSide()				SFRPI=ADCFG4_Page;ADCFG4=ADCFG4|(ADWM0);SFRPI=0

// 设置ADC VREF+
#define ADC_SetVREF_VDD()					SFRPI=ADCFG4_Page;ADCFG4=ADCFG4&(~VRS0);SFRPI=0
#define ADC_SetVREF_IVR24()					SFRPI=ADCFG4_Page;ADCFG4=ADCFG4|(VRS0);SFRPI=0

// 设置ADC的窗口值
#define ADC_SetWindow_High(x)				SFRPI=ADCFG11_Page;ADCFG11=(((x&0x0F)<<4)|0x0F)	;SFRPI=ADCFG12_Page;ADCFG12=((x>>4)&0xFF);SFRPI=0
#define ADC_SetWindow_Low(x)				SFRPI=ADCFG13_Page;ADCFG13=(((x&0x0F)<<4)&0xF0)	;SFRPI=ADCFG14_Page;ADCFG14=((x>>4)&0xFF);SFRPI=0

// 设置ADC 的数据位数
#define ADC_SetADCData_12Bit()				SFRPI=ADCFG3_Page;ADCFG3=ADCFG3&(~(ARES1|ARES0));SFRPI=0
#define ADC_SetADCData_10Bit()				SFRPI=ADCFG3_Page;ADCFG3=(ADCFG3&(~(ARES1|ARES0)))|(ARES0);SFRPI=0
#define ADC_SetADCData_8Bit()				SFRPI=ADCFG3_Page;ADCFG3=(ADCFG3&(~(ARES1|ARES0)))|(ARES1);SFRPI=0

// 设置ADC 转换速度选择
#define ADC_SetADCConversion_30ADCClock()	SFRPI=ADCFG3_Page;ADCFG3=ADCFG3&(~(ADHS1|ADHS));SFRPI=0
#define ADC_SetADCConversion_24ADCClock()	SFRPI=ADCFG3_Page;ADCFG3=(ADCFG3&(~(ADHS1|ADHS)))|(ADHS);SFRPI=0
#define ADC_SetADCConversion_28ADCClock()	SFRPI=ADCFG3_Page;ADCFG3=(ADCFG3&(~(ADHS1|ADHS)))|(ADHS1);SFRPI=0
#define ADC_SetADCConversion_29ADCClock()	SFRPI=ADCFG3_Page;ADCFG3=ADCFG3|(ADHS1|ADHS);SFRPI=0

// 设置ADC 功耗选择
#define ADC_SetADC_HighPower_HighSpeed()	SFRPI=ADCFG3_Page;ADCFG3=ADCFG3&(~(ADPS1|ADPS0));SFRPI=0
#define ADC_SetADC_MHighPower_MHighSpeed()	SFRPI=ADCFG3_Page;ADCFG3=(ADCFG3&(~(ADPS1|ADPS0)))|(ADPS0);SFRPI=0
#define ADC_SetADC_MLowPower_MLowSpeed()	SFRPI=ADCFG3_Page;ADCFG3=(ADCFG3&(~(ADPS1|ADPS0)))|(ADPS1);SFRPI=0
#define ADC_SetADC_LowPower_LowSpeed()		SFRPI=ADCFG3_Page;ADCFG3=ADCFG3|(ADPS1|ADPS0);SFRPI=0

// 设置ADC 通道自动扫描
#define ADC_SetChannelAutoScan(x)			SFRPI=ADCFG5_Page;ADCFG5=x;SFRPI=0

// 设置ADC 自动扫描通道
#define ADC_SetAutoScanCH3_AIN3()			SFRPI=ADCFG7_Page;ADCFG7=ADCFG7&(~ASCS0);SFRPI=0
#define ADC_SetAutoScanCH3_VDD_Div4()		SFRPI=ADCFG7_Page;ADCFG7=ADCFG7|(ASCS0);SFRPI=0
#define ADC_SetAutoScanCH2_AIN2()			SFRPI=ADCFG7_Page;ADCFG7=ADCFG7&(~ASCS1);SFRPI=0
#define ADC_SetAutoScanCH2_OP1O()			SFRPI=ADCFG7_Page;ADCFG7=ADCFG7|(ASCS1);SFRPI=0
#define ADC_SetAutoScanCH1_AIN1()			SFRPI=ADCFG7_Page;ADCFG7=ADCFG7&(~ASCS2);SFRPI=0
#define ADC_SetAutoScanCH1_VSS()			SFRPI=ADCFG7_Page;ADCFG7=ADCFG7|(ASCS2);SFRPI=0
#define ADC_SetAutoScanCH0_AIN0()			SFRPI=ADCFG7_Page;ADCFG7=ADCFG7&(~ASCS3);SFRPI=0
#define ADC_SetAutoScanCH0_OP0O()			SFRPI=ADCFG7_Page;ADCFG7=ADCFG7|(ASCS3);SFRPI=0

// 设置ADC完成标志位ADCI是否产生中断
#define ADC_EnInterrupt_ADCI()				SFRPI=ADCFG1_Page;ADCFG1=ADCFG1&(~IGADCI);SFRPI=0
#define ADC_DisInterrupt_ADCI()				SFRPI=ADCFG1_Page;ADCFG1=ADCFG1|(IGADCI);SFRPI=0

// 设置ADC窗口标志位ADCWI是否产生中断
#define ADC_DisInterrupt_ADCWI()			SFRPI=ADCFG1_Page;ADCFG1=ADCFG1&(~EADCWI);SFRPI=0
#define ADC_EnInterrupt_ADCWI()				SFRPI=ADCFG1_Page;ADCFG1=ADCFG1|(EADCWI);SFRPI=0

// 设置ADC采样完成标志位SFPF是否产生中断
#define ADC_DisInterrupt_SMPF()				SFRPI=ADCFG1_Page;ADCFG1=ADCFG1&(~SMPFIE);SFRPI=0
#define ADC_ENInterrupt_SMPF()				SFRPI=ADCFG1_Page;ADCFG1=ADCFG1|(SMPFIE);SFRPI=0

#define ADC_ClrInterruptFlag()				ADCON0=ADCON0&(~ADCI)

/*
*************************************************************************************
*/

/*
//*************************************************************************************
//*  IVREF
//*
//*************************************************************************************
*/
#define IVR_ENABLE			BIT7
#define IVR_DISABLE			0
#define IVR_OnPD_ENABLE		BIT6
#define IVR_OnPD_DISABLE	0
#define SPWF_RESET_ENABLE	BIT4
#define SPWF_RESET_DISABLE	0

#define SetPCON3(x)			IFD=x;IFADRH=0x0;IFADRL=PCON3_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0

#define IVREF_Enable()						ISPCR=0x80;IFADRH=0x0;IFADRL=PCON3_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0x10))|(IVREN_P);IFADRH=0x0;IFADRL=PCON3_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0
#define IVREF_Disable()						ISPCR=0x80;IFADRH=0x0;IFADRL=PCON3_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0x10));IFADRH=0x0;IFADRL=PCON3_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0

/*
*************************************************************************************
*/

/*
//*************************************************************************************
//*  SPI
//*
//*************************************************************************************
*/
// 开启或关闭SPI
#define SPI_Disable()						SPCON=SPCON&(~SPEN)
#define SPI_Enable()						SPCON=SPCON|(SPEN)

// 选择MASTER/SLAVE
#define SPI_SelectMASTERByMSTRbit()			SPCON=SPCON|(SSIG|MSTR)
#define SPI_SelectSLAVEByMSTRbit()			SPCON=(SPCON|(SSIG))&(~MSTR)
#define SPI_SelectMASTERSLAVEBynSSpin()		SPCON=SPCON&(~SSIG)

// 选择SPICLK 初始电平 0:SPICLK  初始为低电平 1: SPICLK  初始为低电平
#define SPI_SetCPOL_0()						SPCON=SPCON&(~CPOL)
#define SPI_SetCPOL_1()						SPCON=SPCON|(CPOL)

// 选择数据传送顺序	0:高位在先 1: 低位在先
#define SPI_SetDataMSB()					SPCON=SPCON&(~DORD)
#define SPI_SetDataLSB()					SPCON=SPCON|(DORD)

// 选择数据采样模式	0:前沿采样,后沿改变数据 1: 前沿改变数据,后沿采样
#define SPI_SetCPHA_0()						SPCON=SPCON&(~CPHA)
#define SPI_SetCPHA_1()						SPCON=SPCON|(CPHA)

// 选择SPI 的传送速度
#define SPI_CLK_SYSCLK_4	0	// SYSCLK/4
#define SPI_CLK_SYSCLK_8	1	// SYSCLK/8
#define SPI_CLK_SYSCLK_16	2	// SYSCLK/16
#define SPI_CLK_SYSCLK_32	3	// SYSCLK/32
#define SPI_CLK_SYSCLK_64	4	// SYSCLK/64
#define SPI_CLK_SYSCLK_2	5	// SYSCLK/2
#define SPI_CLK_S0TOF_2		6	// S0TOF/2
#define SPI_CLK_T0OF_2		7	// T0OF/2

#define SPI_SetClock(x)						SFRPI=SPCR1_Page;SPCR1=(SPCR1&B11111000)|(x);SFRPI=0

// 开启或关闭菊花链
#define SPI_DisDaisyChain()					SFRPI=SPCR1_Page;SPCR1=SPCR1&(~SPI0M0);SFRPI=0
#define SPI_EnDaisyChain()					SFRPI=SPCR1_Page;SPCR1=SPCR1|SPI0M0;SFRPI=0

// 开启或关闭SPI SO提早采样
#define SPI_SetSOSample_Normal()			SFRPI=SPCR1_Page;SPCR1=SPCR1&(~SPSOES);SFRPI=0
#define SPI_SetSOSample_Early()				SFRPI=SPCR1_Page;SPCR1=SPCR1|SPSOES;SFRPI=0

// 开启或关闭SPI 自动清零SPIF
#define SPI_SetClearSPIF_Soft()				SFRPI=SPCR1_Page;SPCR1=SPCR1&(~SPFACE);SFRPI=0
#define SPI_SetClearSPIF_Auto()				SFRPI=SPCR1_Page;SPCR1=SPCR1|SPFACE;SFRPI=0

// 选择SPI 的引脚 nSS/MOSI/MISO/SPICLK
#define SPI_SetSPInSSMOSIMISOSPICLK_P14P15P16P17()			SFRPI=AUXR10_Page;AUXR10=AUXR10&(~(SPIPS0|SPIPS1));SFRPI=0
#define SPI_SetSPInSSMOSIMISOSPICLK_P01P02P41P40()			SFRPI=AUXR10_Page;AUXR10=(AUXR10&(~(SPIPS0|SPIPS1)))|SPIPS0;SFRPI=0
#define SPI_SetSPInSSMOSIMISOSPICLK_P33P15P16P17()			SFRPI=AUXR10_Page;AUXR10=(AUXR10&(~(SPIPS0|SPIPS1)))|SPIPS1;SFRPI=0
#define SPI_SetSPInSSMOSIMISOSPICL3_P17P35P34P33()			SFRPI=AUXR10_Page;AUXR10=AUXR10|(SPIPS0|SPIPS1);SFRPI=0

// SPI 清/检测SPI完成标志
#define SPI_ClearCompleteFlag()		SPSTAT=SPSTAT|SPIF
#define SPI_ChkCompleteFlag()		(SPSTAT&SPIF)

// SPI 发送/接收数据
#define SPI_SendData(x)		SPDAT=x
#define SPI_GetData()		SPDAT

/*
*************************************************************************************
*/

/*
//*************************************************************************************
//*  PTM0
//*
//*************************************************************************************
*/
// PTM0 开启/关闭计数器
#define	PTM0_EnPCACounter()						CR=1
#define	PTM0_DisPCACounter()					CR=0

// PTM0 设置时钟源, 选择CKMIX16或MCKDO时,必须满足>=SYSCLKx2 & >=CPUCLKx3
#define PTM0_SetCLOCK_SYSCLKdiv12()				CMOD=CMOD&(~(CPS2|CPS1|CPS0))
#define PTM0_SetCLOCK_SYSCLKdiv2()				CMOD=(CMOD&(~(CPS2|CPS1|CPS0)))|(CPS0)
#define PTM0_SetCLOCK_TO()						CMOD=(CMOD&(~(CPS2|CPS1|CPS0)))|(CPS1)
#define PTM0_SetCLOCK_ECI()						CMOD=(CMOD&(~(CPS2|CPS1|CPS0)))|(CPS1|CPS0)
#define PTM0_SetCLOCK_CKMIX16()					CMOD=(CMOD&(~(CPS2|CPS1|CPS0)))|(CPS2)
#define PTM0_SetCLOCK_SYSCLK()					CMOD=(CMOD&(~(CPS2|CPS1|CPS0)))|(CPS2|CPS0)
#define PTM0_SetCLOCK_S0TOF()					CMOD=(CMOD&(~(CPS2|CPS1|CPS0)))|(CPS2|CPS1)
#define PTM0_SetCLOCK_MCKDO()					CMOD=CMOD|(CPS2|CPS1|CPS0)

// PTM0 设置计数器值及其重载值
#define PTM0_SetCounter(x)						CH=HIBYTE(x);CL=LOBYTE(x)
#define PTM0_SetCounterReload(x)				CHRL=HIBYTE(x);CLRL=LOBYTE(x)


// PTM0 设置模式
#define PTM0_CH0_SetMode_16BitSoftwareTimer()	CCAPM0=ECOM0|MAT0
#define PTM0_CH0_SetMode_16BitHighSpeedOutput()	CCAPM0=ECOM0|MAT0|TOG0
#define PTM0_CH0_SetMode_PWM()					CCAPM0=ECOM0|PWM0
#define PTM0_CH0_SetMode_COPM()					CCAPM0=ECOM0|MAT0|TOG0

#define PTM0_CH1_SetMode_16BitSoftwareTimer()	CCAPM1=ECOM1|MAT1
#define PTM0_CH1_SetMode_16BitHighSpeedOutput()	CCAPM1=ECOM1|MAT1|TOG1
#define PTM0_CH1_SetMode_PWM()					CCAPM1=ECOM1|PWM1
#define PTM0_CH1_SetMode_COPM()					CCAPM1=ECOM1|MAT1|TOG1

#define PTM0_CH2_SetMode_16BitSoftwareTimer()	CCAPM2=ECOM2|MAT2
#define PTM0_CH2_SetMode_16BitHighSpeedOutput()	CCAPM2=ECOM2|MAT2|TOG2
#define PTM0_CH2_SetMode_PWM()					CCAPM2=ECOM2|PWM2
#define PTM0_CH2_SetMode_COPM()					CCAPM2=ECOM2|MAT2|TOG2

#define PTM0_CH3_SetMode_16BitSoftwareTimer()	CCAPM3=ECOM3|MAT3
#define PTM0_CH3_SetMode_16BitHighSpeedOutput()	CCAPM3=ECOM3|MAT3|TOG3
#define PTM0_CH3_SetMode_PWM()					CCAPM3=ECOM3|PWM3
#define PTM0_CH3_SetMode_COPM()					CCAPM3=ECOM3|MAT3|TOG3

#define PTM0_CH4_SetMode_16BitSoftwareTimer()	CCAPM4=ECOM4|MAT4
#define PTM0_CH4_SetMode_16BitHighSpeedOutput()	CCAPM4=ECOM4|MAT4|TOG4
#define PTM0_CH4_SetMode_PWM()					CCAPM4=ECOM4|PWM4
#define PTM0_CH4_SetMode_COPM()					CCAPM4=ECOM4|MAT4|TOG4

#define PTM0_CH5_SetMode_16BitSoftwareTimer()	CCAPM5=ECOM5|MAT5
#define PTM0_CH5_SetMode_16BitHighSpeedOutput()	CCAPM5=ECOM5|MAT5|TOG5
#define PTM0_CH5_SetMode_PWM()					CCAPM5=ECOM5|PWM5
#define PTM0_CH5_SetMode_COPM()					CCAPM5=ECOM5|MAT5|TOG5


#define PTM0_CH0_SetPWM_8Bit()					PCAPWM0=PCAPWM0&(~(P0RS0|P0RS1))
#define PTM0_CH0_SetPWM_10Bit()					PCAPWM0=(PCAPWM0&(~(P0RS0|P0RS1)))|(P0RS0)
#define PTM0_CH0_SetPWM_12Bit()					PCAPWM0=(PCAPWM0&(~(P0RS0|P0RS1)))|(P0RS1)
#define PTM0_CH0_SetPWM_16Bit()					PCAPWM0=PCAPWM0|((P0RS0|P0RS1))

#define PTM0_CH1_SetPWM_8Bit()					PCAPWM1=PCAPWM1&(~(P1RS0|P1RS1))
#define PTM0_CH1_SetPWM_10Bit()					PCAPWM1=(PCAPWM1&(~(P1RS0|P1RS1)))|(P1RS0)
#define PTM0_CH1_SetPWM_12Bit()					PCAPWM1=(PCAPWM1&(~(P1RS0|P1RS1)))|(P1RS1)
#define PTM0_CH1_SetPWM_16Bit()					PCAPWM1=PCAPWM1|((P1RS0|P1RS1))

#define PTM0_CH2_SetPWM_8Bit()					PCAPWM2=PCAPWM0&(~(P2RS0|P2RS1))
#define PTM0_CH2_SetPWM_10Bit()					PCAPWM2=(PCAPWM0&(~(P2RS0|P2RS1)))|(P2RS0)
#define PTM0_CH2_SetPWM_12Bit()					PCAPWM2=(PCAPWM0&(~(P2RS0|P2RS1)))|(P2RS1)
#define PTM0_CH2_SetPWM_16Bit()					PCAPWM2=PCAPWM0|((P2RS0|P2RS1))

#define PTM0_CH3_SetPWM_8Bit()					PCAPWM3=PCAPWM0&(~(P3RS0|P3RS1))
#define PTM0_CH3_SetPWM_10Bit()					PCAPWM3=(PCAPWM0&(~(P3RS0|P3RS1)))|(P3RS0)
#define PTM0_CH3_SetPWM_12Bit()					PCAPWM3=(PCAPWM0&(~(P3RS0|P3RS1)))|(P3RS1)
#define PTM0_CH3_SetPWM_16Bit()					PCAPWM3=PCAPWM0|((P3RS0|P3RS1))

#define PTM0_CH4_SetPWM_8Bit()					PCAPWM4=PCAPWM0&(~(P4RS0|P4RS1))
#define PTM0_CH4_SetPWM_10Bit()					PCAPWM4=(PCAPWM0&(~(P4RS0|P4RS1)))|(P4RS0)
#define PTM0_CH4_SetPWM_12Bit()					PCAPWM4=(PCAPWM0&(~(P4RS0|P4RS1)))|(P4RS1)
#define PTM0_CH4_SetPWM_16Bit()					PCAPWM4=PCAPWM0|((P4RS0|P4RS1))

#define PTM0_CH5_SetPWM_8Bit()					PCAPWM5=PCAPWM0&(~(P5RS0|P5RS1))
#define PTM0_CH5_SetPWM_10Bit()					PCAPWM5=(PCAPWM0&(~(P5RS0|P5RS1)))|(P5RS0)
#define PTM0_CH5_SetPWM_12Bit()					PCAPWM5=(PCAPWM0&(~(P5RS0|P5RS1)))|(P5RS1)
#define PTM0_CH5_SetPWM_16Bit()					PCAPWM5=PCAPWM0|((P5RS0|P5RS1))


// PTM0 设置各通道值
#define PTM0_CH0_SetValue(x,y)					AUXR2=AUXR2|(C0PLK);if((x==0)&&(y==0)){PCAPWM0=PCAPWM0|0x03;}else{CCAP0L=y;CCAP0H=x;PCAPWM0=PCAPWM0&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 0 0,1
#define PTM0_CH1_SetValue(x,y)					AUXR2=AUXR2|(C0PLK);if((x==0)&&(y==0)){PCAPWM1=PCAPWM1|0x03;}else{CCAP1L=y;CCAP1H=x;PCAPWM1=PCAPWM1&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 1 0,1
#define PTM0_CH2_SetValue(x,y)					AUXR2=AUXR2|(C0PLK);if((x==0)&&(y==0)){PCAPWM2=PCAPWM2|0x03;}else{CCAP2L=y;CCAP2H=x;PCAPWM2=PCAPWM2&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 2 2,3
#define PTM0_CH3_SetValue(x,y)					AUXR2=AUXR2|(C0PLK);if((x==0)&&(y==0)){PCAPWM3=PCAPWM3|0x03;}else{CCAP3L=y;CCAP3H=x;PCAPWM3=PCAPWM3&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 3 2,3
#define PTM0_CH4_SetValue(x,y)					AUXR2=AUXR2|(C0PLK);if((x==0)&&(y==0)){PCAPWM4=PCAPWM4|0x03;}else{CCAP4L=y;CCAP4H=x;PCAPWM4=PCAPWM4&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 4 4,5
#define PTM0_CH5_SetValue(x,y)					AUXR2=AUXR2|(C0PLK);if((x==0)&&(y==0)){PCAPWM5=PCAPWM5|0x03;}else{CCAP5L=y;CCAP5H=x;PCAPWM5=PCAPWM5&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 5 4,5

#define PTM0_CH0_SetValue_12Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x>=0x10)){PCAPWM0=PCAPWM0|0x03;}else{CCAP0L=y;CCAP0H=x;PCAPWM0=PCAPWM0&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 0 0,1
#define PTM0_CH1_SetValue_12Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x>=0x10)){PCAPWM1=PCAPWM1|0x03;}else{CCAP1L=y;CCAP1H=x;PCAPWM1=PCAPWM1&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 1 0,1
#define PTM0_CH2_SetValue_12Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x>=0x10)){PCAPWM2=PCAPWM2|0x03;}else{CCAP2L=y;CCAP2H=x;PCAPWM2=PCAPWM2&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 2 2,3
#define PTM0_CH3_SetValue_12Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x>=0x10)){PCAPWM3=PCAPWM3|0x03;}else{CCAP3L=y;CCAP3H=x;PCAPWM3=PCAPWM3&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 3 2,3
#define PTM0_CH4_SetValue_12Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x>=0x10)){PCAPWM4=PCAPWM4|0x03;}else{CCAP4L=y;CCAP4H=x;PCAPWM4=PCAPWM4&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 4 4,5
#define PTM0_CH5_SetValue_12Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x>=0x10)){PCAPWM5=PCAPWM5|0x03;}else{CCAP5L=y;CCAP5H=x;PCAPWM5=PCAPWM5&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 5 4,5

#define PTM0_CH0_SetValue_10Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x>=0x04)){PCAPWM0=PCAPWM0|0x03;}else{CCAP0L=y;CCAP0H=x;PCAPWM0=PCAPWM0&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 0 0,1
#define PTM0_CH1_SetValue_10Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x>=0x04)){PCAPWM1=PCAPWM1|0x03;}else{CCAP1L=y;CCAP1H=x;PCAPWM1=PCAPWM1&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 1 0,1
#define PTM0_CH2_SetValue_10Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x>=0x04)){PCAPWM2=PCAPWM2|0x03;}else{CCAP2L=y;CCAP2H=x;PCAPWM2=PCAPWM2&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 2 2,3
#define PTM0_CH3_SetValue_10Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x>=0x04)){PCAPWM3=PCAPWM3|0x03;}else{CCAP3L=y;CCAP3H=x;PCAPWM3=PCAPWM3&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 3 2,3
#define PTM0_CH4_SetValue_10Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x>=0x04)){PCAPWM4=PCAPWM4|0x03;}else{CCAP4L=y;CCAP4H=x;PCAPWM4=PCAPWM4&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 4 4,5
#define PTM0_CH5_SetValue_10Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x>=0x04)){PCAPWM5=PCAPWM5|0x03;}else{CCAP5L=y;CCAP5H=x;PCAPWM5=PCAPWM5&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 5 4,5

#define PTM0_CH0_SetValue_8Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x!=0)){PCAPWM0=PCAPWM0|0x02;}else{CCAP0H=y;PCAPWM0=PCAPWM0&(~0x02);};AUXR2=AUXR2&(~C0PLK)		// 0
#define PTM0_CH1_SetValue_8Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x!=0)){PCAPWM1=PCAPWM1|0x02;}else{CCAP1H=y;PCAPWM1=PCAPWM1&(~0x02);};AUXR2=AUXR2&(~C0PLK)		// 1
#define PTM0_CH2_SetValue_8Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x!=0)){PCAPWM2=PCAPWM2|0x02;}else{CCAP2H=y;PCAPWM2=PCAPWM2&(~0x02);};AUXR2=AUXR2&(~C0PLK)		// 2
#define PTM0_CH3_SetValue_8Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x!=0)){PCAPWM3=PCAPWM3|0x02;}else{CCAP3H=y;PCAPWM3=PCAPWM3&(~0x02);};AUXR2=AUXR2&(~C0PLK)		// 3
#define PTM0_CH4_SetValue_8Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x!=0)){PCAPWM4=PCAPWM4|0x02;}else{CCAP4H=y;PCAPWM4=PCAPWM4&(~0x02);};AUXR2=AUXR2&(~C0PLK)		// 4
#define PTM0_CH5_SetValue_8Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x!=0)){PCAPWM5=PCAPWM5|0x02;}else{CCAP5H=y;PCAPWM5=PCAPWM5&(~0x02);};AUXR2=AUXR2&(~C0PLK)		// 5



#define PTM0_CH0_SetValue_L(x)					CCAP0L=x                        // 0
#define PTM0_CH1_SetValue_L(x)					CCAP1L=x                        // 1
#define PTM0_CH2_SetValue_L(x)					CCAP2L=x                        // 2
#define PTM0_CH3_SetValue_L(x)					CCAP3L=x                        // 3
#define PTM0_CH4_SetValue_L(x)					CCAP4L=x                        // 4
#define PTM0_CH5_SetValue_L(x)					CCAP5L=x                        // 5

#define PTM0_CH0_SetValue_H(x)					CCAP0H=x						// 0
#define PTM0_CH1_SetValue_H(x)					CCAP1H=x                        // 1
#define PTM0_CH2_SetValue_H(x)					CCAP2H=x                        // 2
#define PTM0_CH3_SetValue_H(x)					CCAP3H=x                        // 3
#define PTM0_CH4_SetValue_H(x)					CCAP4H=x                        // 4
#define PTM0_CH5_SetValue_H(x)					CCAP5H=x                        // 5

#define PTM0_CH0_SetValue_9thBit_L_0()			PCAPWM0=PCAPWM0&(~0x01)        	// 0
#define PTM0_CH1_SetValue_9thBit_L_0()			PCAPWM1=PCAPWM1&(~0x01)         // 1
#define PTM0_CH2_SetValue_9thBit_L_0()			PCAPWM2=PCAPWM2&(~0x01)         // 2
#define PTM0_CH3_SetValue_9thBit_L_0()			PCAPWM3=PCAPWM3&(~0x01)         // 3
#define PTM0_CH4_SetValue_9thBit_L_0()			PCAPWM4=PCAPWM4&(~0x01)         // 4
#define PTM0_CH5_SetValue_9thBit_L_0()			PCAPWM5=PCAPWM5&(~0x01)         // 5

#define PTM0_CH0_SetValue_9thBit_L_1()			PCAPWM0=PCAPWM0|(0x01)        	// 0
#define PTM0_CH1_SetValue_9thBit_L_1()			PCAPWM1=PCAPWM1|(0x01)         // 1
#define PTM0_CH2_SetValue_9thBit_L_1()			PCAPWM2=PCAPWM2|(0x01)         // 2
#define PTM0_CH3_SetValue_9thBit_L_1()			PCAPWM3=PCAPWM3|(0x01)         // 3
#define PTM0_CH4_SetValue_9thBit_L_1()			PCAPWM4=PCAPWM4|(0x01)         // 4
#define PTM0_CH5_SetValue_9thBit_L_1()			PCAPWM5=PCAPWM5|(0x01)         // 5

#define PTM0_CH0_SetValue_9thBit_H_0()			PCAPWM0=PCAPWM0&(~0x02)        	// 0
#define PTM0_CH1_SetValue_9thBit_H_0()			PCAPWM1=PCAPWM1&(~0x02)         // 1
#define PTM0_CH2_SetValue_9thBit_H_0()			PCAPWM2=PCAPWM2&(~0x02)         // 2
#define PTM0_CH3_SetValue_9thBit_H_0()			PCAPWM3=PCAPWM3&(~0x02)         // 3
#define PTM0_CH4_SetValue_9thBit_H_0()			PCAPWM4=PCAPWM4&(~0x02)         // 4
#define PTM0_CH5_SetValue_9thBit_H_0()			PCAPWM5=PCAPWM5&(~0x02)         // 5

#define PTM0_CH0_SetValue_9thBit_H_1()			PCAPWM0=PCAPWM0|(0x02)        	// 0
#define PTM0_CH1_SetValue_9thBit_H_1()			PCAPWM1=PCAPWM1|(0x02)         // 1
#define PTM0_CH2_SetValue_9thBit_H_1()			PCAPWM2=PCAPWM2|(0x02)         // 2
#define PTM0_CH3_SetValue_9thBit_H_1()			PCAPWM3=PCAPWM3|(0x02)         // 3
#define PTM0_CH4_SetValue_9thBit_H_1()			PCAPWM4=PCAPWM4|(0x02)         // 4
#define PTM0_CH5_SetValue_9thBit_H_1()			PCAPWM5=PCAPWM5|(0x02)         // 5

// PTM0 设置PWM输出反向
#define PTM0_CH0_SetPWM_EnInvert()				PCAPWM0=PCAPWM0|P0INV
#define PTM0_CH1_SetPWM_EnInvert()				PCAPWM1=PCAPWM1|P1INV
#define PTM0_CH2_SetPWM_EnInvert()				PCAPWM2=PCAPWM2|P2INV
#define PTM0_CH3_SetPWM_EnInvert()				PCAPWM3=PCAPWM3|P3INV
#define PTM0_CH4_SetPWM_EnInvert()				PCAPWM4=PCAPWM4|P4INV
#define PTM0_CH5_SetPWM_EnInvert()				PCAPWM5=PCAPWM5|P5INV

#define PTM0_CH0_SetPWM_DisInvert()				PCAPWM0=PCAPWM0&(~(P0INV))
#define PTM0_CH1_SetPWM_DisInvert()				PCAPWM1=PCAPWM1&(~(P1INV))
#define PTM0_CH2_SetPWM_DisInvert()				PCAPWM2=PCAPWM2&(~(P2INV))
#define PTM0_CH3_SetPWM_DisInvert()				PCAPWM3=PCAPWM3&(~(P3INV))
#define PTM0_CH4_SetPWM_DisInvert()				PCAPWM4=PCAPWM4&(~(P4INV))
#define PTM0_CH5_SetPWM_DisInvert()				PCAPWM5=PCAPWM5&(~(P5INV))

// PTM0 使能/禁止PWM输出
#define PTM0_SetPWM0_EnOutput()					PAOE=PAOE|(POE0)
#define PTM0_SetPWM1_EnOutput()					PAOE=PAOE|(POE1)
#define PTM0_SetPWM2_EnOutput()					PAOE=PAOE|(POE2)
#define PTM0_SetPWM3_EnOutput()					PAOE=PAOE|(POE3)
#define PTM0_SetPWM0_2nd_EnOutput()				PAOE=PAOE|(POE0A)
#define PTM0_SetPWM0_3rd_EnOutput()				PAOE=PAOE|(POE0B)
#define PTM0_SetPWM2_2nd_EnOutput()				PAOE=PAOE|(POE2A)
#define PTM0_SetPWM2_3rd_EnOutput()				PAOE=PAOE|(POE2B)
#define PTM0_SetPWM4_EnOutput()					SFRPI=C0AOE1_Page;C0AOE1=C0AOE1|(POE4);SFRPI=0
#define PTM0_SetPWM5_EnOutput()					SFRPI=C0AOE1_Page;C0AOE1=C0AOE1|(POE5);SFRPI=0

#define PTM0_SetPWM0_DisOutput()					PAOE=PAOE&(~POE0)
#define PTM0_SetPWM1_DisOutput()					PAOE=PAOE&(~POE1)
#define PTM0_SetPWM2_DisOutput()					PAOE=PAOE&(~POE2)
#define PTM0_SetPWM3_DisOutput()					PAOE=PAOE&(~POE3)
#define PTM0_SetPWM0_2nd_DisOutput()				PAOE=PAOE&(~POE0A)
#define PTM0_SetPWM0_3rd_DisOutput()				PAOE=PAOE&(~POE0B)
#define PTM0_SetPWM2_2nd_DisOutput()				PAOE=PAOE&(~POE2A)
#define PTM0_SetPWM2_3rd_DisOutput()				PAOE=PAOE&(~POE2B)
#define PTM0_SetPWM4_DisOutput()					SFRPI=C0AOE1_Page;C0AOE1=C0AOE1&(~POE4);SFRPI=0
#define PTM0_SetPWM5_DisOutput()					SFRPI=C0AOE1_Page;C0AOE1=C0AOE1&(~POE5);SFRPI=0

// PTM0 设置POEn功能生效方法
#define PTM0_SetPOEn_WrCpu()						SFRPI=C0AOE1_Page;C0AOE1=C0AOE1&(~POEM0);SFRPI=0
#define PTM0_SetPOEn_PWMCycle()						SFRPI=C0AOE1_Page;C0AOE1=C0AOE1|(POEM0);SFRPI=0

// PTM0 设置PWM 缓冲模式
#define PTM0_CH01_SetPWM_EnBufferMode()				CMOD=CMOD|BME0
#define PTM0_CH23_SetPWM_EnBufferMode()				CMOD=CMOD|BME2
#define PTM0_CH45_SetPWM_EnBufferMode()				CMOD=CMOD|BME4
#define PTM0_CH01_SetPWM_DisBufferMode()			CMOD=CMOD&(~(BME0))
#define PTM0_CH23_SetPWM_DisBufferMode()			CMOD=CMOD&(~(BME2))
#define PTM0_CH45_SetPWM_DisBufferMode()			CMOD=CMOD&(~(BME4))

// PTM0 设置PWM 死区, 必须在缓冲模式下才有效
#define PTM0_CH01_SetPWM_EnDeadTime()				CCAPM0=CCAPM0|DTE0
#define PTM0_CH23_SetPWM_EnDeadTime()				CCAPM2=CCAPM2|DTE2
#define PTM0_CH45_SetPWM_EnDeadTime()				CCAPM4=CCAPM4|DTE4
#define PTM0_CH01_SetPWM_DisDeadTime()				CCAPM0=CCAPM0&(~(DTE0))
#define PTM0_CH23_SetPWM_DisDeadTime()				CCAPM2=CCAPM2&(~(DTE2))
#define PTM0_CH45_SetPWM_DisDeadTime()				CCAPM4=CCAPM4&(~(DTE4))

// PTM0 设置死区预分频
#define PTM0_SetDeadTimePreScaler_Sysclk()			SFRPI=PDTCRA_Page;PDTCRA=(PDTCRA&(~(DTPS1|DTPS0)));SFRPI=0
#define PTM0_SetDeadTimePreScaler_SysclkDiv2()		SFRPI=PDTCRA_Page;PDTCRA=(PDTCRA&(~(DTPS1|DTPS0)))|(DTPS0);SFRPI=0
#define PTM0_SetDeadTimePreScaler_SysclkDiv4()		SFRPI=PDTCRA_Page;PDTCRA=(PDTCRA&(~(DTPS1|DTPS0)))|(DTPS1);SFRPI=0
#define PTM0_SetDeadTimePreScaler_SysclkDiv8()		SFRPI=PDTCRA_Page;PDTCRA=(PDTCRA|((DTPS1|DTPS0)));SFRPI=0

// PTM0 设置死区时间周期 PreScaler*(x) 0:DT无效, 1~63:PreScaler*(1~63)
#define PTM0_SetDeadTimePeriod(x)					SFRPI=PDTCRA_Page;PDTCRA=(PDTCRA&((DTPS1|DTPS0)))|x;SFRPI=0

// PTM0 设置重载使能
#define PTM0_EnPCAReload()							AUXR2=AUXR2&(~C0PLK)
#define PTM0_DisPCAReload()							AUXR2=AUXR2|(C0PLK)

// PTM0 设置中断

#define PTM0_CF_EnInterrupt()				CMOD=CMOD|ECF
#define PTM0_CF_DisInterrupt()				CMOD=CMOD&(~(ECF))

#define PTM0_CH0_EnInterrupt()				CCAPM0=CCAPM0|ECCF0
#define PTM0_CH1_EnInterrupt()				CCAPM1=CCAPM1|ECCF1
#define PTM0_CH2_EnInterrupt()				CCAPM2=CCAPM2|ECCF2
#define PTM0_CH3_EnInterrupt()				CCAPM3=CCAPM3|ECCF3
#define PTM0_CH4_EnInterrupt()				CCAPM4=CCAPM4|ECCF4
#define PTM0_CH5_EnInterrupt()				CCAPM5=CCAPM5|ECCF5

#define PTM0_CH0_DisInterrupt()				CCAPM0=CCAPM0&(~(ECCF0))
#define PTM0_CH1_DisInterrupt()				CCAPM1=CCAPM1&(~(ECCF1))
#define PTM0_CH2_DisInterrupt()				CCAPM2=CCAPM2&(~(ECCF2))
#define PTM0_CH3_DisInterrupt()				CCAPM3=CCAPM3&(~(ECCF3))
#define PTM0_CH4_DisInterrupt()				CCAPM4=CCAPM4&(~(ECCF4))
#define PTM0_CH5_DisInterrupt()				CCAPM5=CCAPM5&(~(ECCF5))

// PTM0 设置PWM对齐方式
#define PTM0_SetPWM_EdgeAligned()			PWMCR=PWMCR&(~PCAE)
#define PTM0_SetPWM_CenterAligned()			PWMCR=PWMCR|(PCAE)

// PTM0 设置PWM在中心对齐时CF在顶端/底端置位
#define PTM0_SetCenterAligned_CFonTop()		PWMCR=PWMCR&(~C0OFS)
#define PTM0_SetCenterAligned_CFonBottom()	PWMCR=PWMCR|(C0OFS)

// PTM0 设置时钟输出
#define PTM0_SetClkOuput_Disable()			SFRPI=AUXR7_Page;AUXR7=AUXR7&(~C0CKOE);SFRPI=0
#define PTM0_SetClkOuput_Enable()			SFRPI=AUXR7_Page;AUXR7=AUXR7|(C0CKOE);SFRPI=0

// PTM0 引脚设置
#define PTM0_SetECI_P02()					SFRPI=AUXR5_Page;AUXR5=AUXR5&(~ECIPS0);SFRPI=0
#define PTM0_SetECI_P16()					SFRPI=AUXR5_Page;AUXR5=AUXR5|(ECIPS0);SFRPI=0

#define PTM0_SetC0CKO_P47()					SFRPI=AUXR5_Page;AUXR5=AUXR5&(~C0COPS);SFRPI=0
#define PTM0_SetC0CKO_P33()					SFRPI=AUXR5_Page;AUXR5=AUXR5|(C0COPS);SFRPI=0

#define PTM0_SetPWM0APWM0B_P36P37()			SFRPI=AUXR5_Page;AUXR5=AUXR5&(~C0PPS0);SFRPI=0
#define PTM0_SetPWM0APWM0B_P60P61()			SFRPI=AUXR5_Page;AUXR5=AUXR5|(C0PPS0);SFRPI=0

#define PTM0_SetPWM2APWM2B_P40P41()			SFRPI=AUXR5_Page;AUXR5=AUXR5&(~C0PPS1);SFRPI=0
#define PTM0_SetPWM2APWM2B_P34P35()			SFRPI=AUXR5_Page;AUXR5=AUXR5|(C0PPS1);SFRPI=0

#define PTM0_SetCEX0_P22()					SFRPI=AUXR16_Page;AUXR16=AUXR16&(~C0OPS0);SFRPI=0
#define PTM0_SetCEX0_P40()					SFRPI=AUXR16_Page;AUXR16=AUXR16|C0OPS0;SFRPI=0
#define PTM0_SetCEX1_P23()					SFRPI=AUXR16_Page;AUXR16=AUXR16&(~C0OPS1);SFRPI=0
#define PTM0_SetCEX1_P33()					SFRPI=AUXR16_Page;AUXR16=AUXR16|C0OPS1;SFRPI=0
#define PTM0_SetCEX2_P24()					SFRPI=AUXR16_Page;AUXR16=AUXR16&(~C0OPS2);SFRPI=0
#define PTM0_SetCEX2_P41()					SFRPI=AUXR16_Page;AUXR16=AUXR16|C0OPS2;SFRPI=0
#define PTM0_SetCEX3_P05()					SFRPI=AUXR16_Page;AUXR16=AUXR16&(~C0OPS3);SFRPI=0
#define PTM0_SetCEX3_P34()					SFRPI=AUXR16_Page;AUXR16=AUXR16|C0OPS3;SFRPI=0
#define PTM0_SetCEX4_P26()					SFRPI=AUXR16_Page;AUXR16=AUXR16&(~C0OPS4);SFRPI=0
#define PTM0_SetCEX4_P32()					SFRPI=AUXR16_Page;AUXR16=AUXR16|C0OPS4;SFRPI=0
#define PTM0_SetCEX5_P07()					SFRPI=AUXR16_Page;AUXR16=AUXR16&(~C0OPS5);SFRPI=0
#define	PTM0_SetCEX5_P35()					SFRPI=AUXR16_Page;AUXR16=AUXR16|C0OPS5;SFRPI=0

#define CEX0_P22	0
#define CEX0_P40	BIT0
#define CEX1_P23	0
#define CEX1_P33	BIT1
#define CEX2_P24	0
#define CEX2_P41	BIT2
#define CEX3_P05	0
#define CEX3_P34	BIT3
#define CEX4_P26	0
#define CEX4_P32	BIT4
#define CEX5_P07	0
#define CEX5_P35	BIT5
#define	PTM0_SetCEXn_Pin(x)					SFRPI=AUXR16_Page;AUXR16=(AUXR16&(~(C0OPS0|C0OPS1|C0OPS2|C0OPS3|C0OPS4|C0OPS5)))|x;SFRPI=0

/*
*************************************************************************************
*/

/*
*************************************************************************************
*  PCA1
*
*************************************************************************************
*/
// PCA1 开启/关闭计数器
#define	PCA1_EnPCACounter()					SFRPI=C1CON_Page;C1R=1;SFRPI=0
#define	PCA1_DisPCACounter()				SFRPI=C1CON_Page;C1R=0;SFRPI=0

// PCA1 设置时钟源, 选择CKMIX16或MCKDO时,必须满足>=SYSCLKx2 & >=CPUCLKx3
#define PCA1_SetCLOCK_SYSCLKdiv12()			SFRPI=C1MOD_Page;C1MOD=C1MOD&(~(CPS2|CPS1|CPS0));SFRPI=0
#define PCA1_SetCLOCK_SYSCLKdiv2()			SFRPI=C1MOD_Page;C1MOD=(C1MOD&(~(CPS2|CPS1|CPS0)))|(CPS0);SFRPI=0
#define PCA1_SetCLOCK_TO()					SFRPI=C1MOD_Page;C1MOD=(C1MOD&(~(CPS2|CPS1|CPS0)))|(CPS1);SFRPI=0
#define PCA1_SetCLOCK_ECI()					SFRPI=C1MOD_Page;C1MOD=(C1MOD&(~(CPS2|CPS1|CPS0)))|(CPS1|CPS0);SFRPI=0
#define PCA1_SetCLOCK_CKMIX16()				SFRPI=C1MOD_Page;C1MOD=(C1MOD&(~(CPS2|CPS1|CPS0)))|(CPS2);SFRPI=0
#define PCA1_SetCLOCK_SYSCLK()				SFRPI=C1MOD_Page;C1MOD=(C1MOD&(~(CPS2|CPS1|CPS0)))|(CPS2|CPS0);SFRPI=0
#define PCA1_SetCLOCK_S0BRT()				SFRPI=C1MOD_Page;C1MOD=(C1MOD&(~(CPS2|CPS1|CPS0)))|(CPS2|CPS1);SFRPI=0
#define PCA1_SetCLOCK_MCKDO()				SFRPI=C1MOD_Page;C1MOD=C1MOD|(CPS2|CPS1|CPS0);SFRPI=0

// PCA1 设置计数器值及其重载值
#define PCA1_SetCounter(x)					SFRPI=CH1_Page;CH1=HIBYTE(x);CL1=LOBYTE(x);SFRPI=0
#define PCA1_SetCounterReload(x)			SFRPI=CH1RL_Page;CH1RL=HIBYTE(x);CL1RL=LOBYTE(x);SFRPI=0


// PCA1 设置模式
#define PCA1_CH0_SetMode_16BitCaptureRising()	SFRPI=C1CAPM0_Page;C1CAPM0=CAP1P0;SFRPI=0
#define PCA1_CH0_SetMode_16BitCaptureFalling()	SFRPI=C1CAPM0_Page;C1CAPM0=CAP1N0;SFRPI=0
#define PCA1_CH0_SetMode_16BitCaptureDaul()		SFRPI=C1CAPM0_Page;C1CAPM0=CAP1P0|CAP1N0;SFRPI=0
#define PCA1_CH0_SetMode_16BitSoftwareTimer()	SFRPI=C1CAPM0_Page;C1CAPM0=ECOM01|MAT01;SFRPI=0
#define PCA1_CH0_SetMode_16BitHighSpeedOutput()	SFRPI=C1CAPM0_Page;C1CAPM0=ECOM01|MAT01|TOG01;SFRPI=0
#define PCA1_CH0_SetMode_PWM()					SFRPI=C1CAPM0_Page;C1CAPM0=ECOM01|PWM01;SFRPI=0

#define PCA1_CH1_SetMode_16BitCaptureRising()	SFRPI=C1CAPM1_Page;C1CAPM1=CAP1P1;SFRPI=0
#define PCA1_CH1_SetMode_16BitCaptureFalling()	SFRPI=C1CAPM1_Page;C1CAPM1=CAP1N1;SFRPI=0
#define PCA1_CH1_SetMode_16BitCaptureDaul()		SFRPI=C1CAPM1_Page;C1CAPM1=CAP1P1|CAP1N1;SFRPI=0
#define PCA1_CH1_SetMode_16BitSoftwareTimer()	SFRPI=C1CAPM1_Page;C1CAPM1=ECOM11|MAT11;SFRPI=0
#define PCA1_CH1_SetMode_16BitHighSpeedOutput()	SFRPI=C1CAPM1_Page;C1CAPM1=ECOM11|MAT11|TOG11;SFRPI=0
#define PCA1_CH1_SetMode_PWM()					SFRPI=C1CAPM1_Page;C1CAPM1=ECOM11|PWM11;SFRPI=0

#define PCA1_CH0_SetPWM_8Bit()					SFRPI=C1PWM0_Page;C1PWM0=C1PWM0&(~(P0RS01|P0RS11));SFRPI=0
#define PCA1_CH0_SetPWM_10Bit()					SFRPI=C1PWM0_Page;C1PWM0=(C1PWM0&(~(P0RS01|P0RS11)))|(P0RS0);SFRPI=0
#define PCA1_CH0_SetPWM_12Bit()					SFRPI=C1PWM0_Page;C1PWM0=(C1PWM0&(~(P0RS01|P0RS11)))|(P0RS1);SFRPI=0
#define PCA1_CH0_SetPWM_16Bit()					SFRPI=C1PWM0_Page;C1PWM0=C1PWM0|((P0RS01|P0RS11));SFRPI=0

#define PCA1_CH1_SetPWM_8Bit()					SFRPI=C1PWM0_Page;C1PWM1=C1PWM1&(~(P1RS01|P1RS11));SFRPI=0
#define PCA1_CH1_SetPWM_10Bit()					SFRPI=C1PWM0_Page;C1PWM1=(C1PWM1&(~(P1RS01|P1RS11)))|(P1RS01);SFRPI=0
#define PCA1_CH1_SetPWM_12Bit()					SFRPI=C1PWM0_Page;C1PWM1=(C1PWM1&(~(P1RS01|P1RS11)))|(P1RS11);SFRPI=0
#define PCA1_CH1_SetPWM_16Bit()					SFRPI=C1PWM0_Page;C1PWM1=C1PWM1|((P1RS01|P1RS11));SFRPI=0



// PCA1 设置各通道值
#define PCA1_CH0_SetValue(x,y)					AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x==0)&&(y==0)){C1PWM0=C1PWM0|0x03;}else{C1CAP0L=y;C1CAP0H=x;C1PWM0=C1PWM0&(~0x03);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)	// 0 0,1
#define PCA1_CH1_SetValue(x,y)					AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x==0)&&(y==0)){C1PWM1=C1PWM1|0x03;}else{C1CAP1L=y;C1CAP1H=x;C1PWM1=C1PWM1&(~0x03);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)	// 1 0,1

#define PCA1_CH0_SetValue_12Bit(x,y)			AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x>=0x10)){C1PWM0=C1PWM0|0x03;}else{C1CAP0L=y;C1CAP0H=x;C1PWM0=C1PWM0&(~0x03);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)		// 0 0,1
#define PCA1_CH1_SetValue_12Bit(x,y)			AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x>=0x10)){C1PWM1=C1PWM1|0x03;}else{C1CAP1L=y;C1CAP1H=x;C1PWM1=C1PWM1&(~0x03);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)		// 1 0,1

#define PCA1_CH0_SetValue_10Bit(x,y)			AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x>=0x04)){C1PWM0=C1PWM0|0x03;}else{C1CAP0L=y;C1CAP0H=x;C1PWM0=C1PWM0&(~0x03);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)		// 0 0,1
#define PCA1_CH1_SetValue_10Bit(x,y)			AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x>=0x04)){C1PWM1=C1PWM1|0x03;}else{C1CAP1L=y;C1CAP1H=x;C1PWM1=C1PWM1&(~0x03);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)		// 1 0,1

#define PCA1_CH0_SetValue_8Bit(x,y)				AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x!=0)){C1PWM0=C1PWM0|0x02;}else{C1CAP0H=y;C1PWM0=C1PWM0&(~0x02);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)		// 0
#define PCA1_CH1_SetValue_8Bit(x,y)				AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x!=0)){C1PWM1=C1PWM1|0x02;}else{C1CAP1H=y;C1PWM1=C1PWM1&(~0x02);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)		// 1

#define PCA1_CH0_SetValue_L(x)					SFRPI=1;C1CAP0L=x;SFRPI=0
#define PCA1_CH1_SetValue_L(x)					SFRPI=1;C1CAP1L=x;SFRPI=0

#define PCA1_CH0_SetValue_H(x)					SFRPI=1;C1CAP0H=x;SFRPI=0
#define PCA1_CH1_SetValue_H(x)					SFRPI=1;C1CAP1H=x;SFRPI=0

#define PCA1_CH0_SetValue_9thBit_L_0()			SFRPI=1;C1PWM0=C1PWM0&(~0x01);SFRPI=0
#define PCA1_CH1_SetValue_9thBit_L_0()			SFRPI=1;C1PWM1=C1PWM1&(~0x01);SFRPI=0

#define PCA1_CH0_SetValue_9thBit_L_1()			SFRPI=1;C1PWM0=C1PWM0|(0x01);SFRPI=0
#define PCA1_CH1_SetValue_9thBit_L_1()			SFRPI=1;C1PWM1=C1PWM1|(0x01);SFRPI=0

#define PCA1_CH0_SetValue_9thBit_H_0()			SFRPI=1;C1PWM0=C1PWM0&(~0x02);SFRPI=0
#define PCA1_CH1_SetValue_9thBit_H_0()			SFRPI=1;C1PWM1=C1PWM1&(~0x02);SFRPI=0

#define PCA1_CH0_SetValue_9thBit_H_1()			SFRPI=1;C1PWM0=C1PWM0|(0x02);SFRPI=0
#define PCA1_CH1_SetValue_9thBit_H_1()			SFRPI=1;C1PWM1=C1PWM1|(0x02);SFRPI=0

// PCA1 设置PWM输出反向
#define PCA1_CH0_SetPWM_EnInvert()				SFRPI=1;C1PWM0=C1PWM0|P0INV;SFRPI=0
#define PCA1_CH1_SetPWM_EnInvert()				SFRPI=1;C1PWM1=C1PWM1|P1INV;SFRPI=0

#define PCA1_CH0_SetPWM_DisInvert()				SFRPI=1;C1PWM0=C1PWM0&(~(P0INV));SFRPI=0
#define PCA1_CH1_SetPWM_DisInvert()				SFRPI=1;C1PWM1=C1PWM1&(~(P1INV));SFRPI=0

// PCA 使能/禁止PWM
#define PCA1_CH0_EnPWM()						SFRPI=1;C1CAPM0=C1CAPM0|PWM0;SFRPI=0
#define PCA1_CH1_EnPWM()						SFRPI=1;C1CAPM1=C1CAPM1|PWM1;SFRPI=0

#define PCA1_CH0_DisPWM()						SFRPI=1;C1CAPM0=C1CAPM0&(~PWM0);SFRPI=0
#define PCA1_CH1_DisPWM()       				SFRPI=1;C1CAPM1=C1CAPM1&(~PWM1);SFRPI=0

// PCA1 使能/禁止PWM输出
#define PCA1_SetPWM0_EnOutput()					SFRPI=C1AOE0_Page;C1AOE0=C1AOE0|(C1POE0);SFRPI=0
#define PCA1_SetPWM1_EnOutput()					SFRPI=C1AOE0_Page;C1AOE0=C1AOE0|(C1POE1);SFRPI=0

#define PCA1_SetPWM0_DisOutput()				SFRPI=C1AOE0_Page;C1AOE0=C1AOE0&(~C1POE0);SFRPI=0
#define PCA1_SetPWM1_DisOutput()				SFRPI=C1AOE0_Page;C1AOE0=C1AOE0&(~C1POE1);SFRPI=0

// PCA1 设置PWM 缓冲模式
#define PCA1_CH01_SetPWM_EnBufferMode()			SFRPI=C1MOD_Page;C1MOD=C1MOD|BME01;SFRPI=0
#define PCA1_CH01_SetPWM_DisBufferMode()		SFRPI=C1MOD_Page;C1MOD=C1MOD&(~BME01);SFRPI=0

// PCA1 设置中断

#define PCA1_CF_EnInterrupt()				SFRPI=C1MOD_Page;C1MOD=C1MOD|ECF1;SFRPI=0
#define PCA1_CF_DisInterrupt()				SFRPI=C1MOD_Page;C1MOD=C1MOD&(~(ECF1));SFRPI=0

#define PCA1_CH0_EnInterrupt()				SFRPI=C1CAPM0_Page;C1CAPM0=C1CAPM0|EC1CF0;SFRPI=0
#define PCA1_CH1_EnInterrupt()				SFRPI=C1CAPM1_Page;C1CAPM1=C1CAPM1|EC1CF1;SFRPI=0

#define PCA1_CH0_DisInterrupt()				SFRPI=C1CAPM0_Page;C1CAPM0=C1CAPM0&(~(EC1CF0));SFRPI=0
#define PCA1_CH1_DisInterrupt()				SFRPI=C1CAPM1_Page;C1CAPM1=C1CAPM1&(~(EC1CF1));SFRPI=0

// PCA1 设置PWM对齐方式
#define PCA1_SetPWM_EdgeAligned()			SFRPI=C1PWMCR_Page;C1PWMCR=C1PWMCR&(~PCA1E);SFRPI=0
#define PCA1_SetPWM_CenterAligned()			SFRPI=C1PWMCR_Page;C1PWMCR=C1PWMCR|(PCA1E);SFRPI=0

// PCA1 设置PWM在中心对齐时CF在顶端/底端置位
#define PCA1_SetCenterAligned_CFonTop()		SFRPI=C1PWMCR_Page;C1PWMCR=C1PWMCR&(~C1OFS);SFRPI=0
#define PCA1_SetCenterAligned_CFonBottom()	SFRPI=C1PWMCR_Page;C1PWMCR=C1PWMCR|(C1OFS);SFRPI=0

// PCA1 设置时钟输出
#define PCA1_SetClkOuput_Disable()			SFRPI=AUXR7_Page;AUXR7=AUXR7&(~C1CKOE);SFRPI=0
#define PCA1_SetClkOuput_Enable()			SFRPI=AUXR7_Page;AUXR7=AUXR7|(C1CKOE);SFRPI=0

// PCA1 设置Break
#define PCA1_SetBreakSource0_Disable()		SFRPI=C1PWMCR_Page;C1PWMCR=C1PWMCR&(~(C1BKE00|C1BKE01|C1BKE02));SFRPI=0
#define PCA1_SetBreakSource0_AC0OUT()		SFRPI=C1PWMCR_Page;C1PWMCR=(C1PWMCR&(~(C1BKE00|C1BKE01|C1BKE02)))|(C1BKE00);SFRPI=0
#define PCA1_SetBreakSource0_INT1ET()		SFRPI=C1PWMCR_Page;C1PWMCR=(C1PWMCR&(~(C1BKE00|C1BKE01|C1BKE02)))|(C1BKE01);SFRPI=0
#define PCA1_SetBreakSource0_T2EXI()		SFRPI=C1PWMCR_Page;C1PWMCR=(C1PWMCR&(~(C1BKE00|C1BKE01|C1BKE02)))|(C1BKE01|C1BKE00);SFRPI=0
#define PCA1_SetBreakSource0_KBIET()		SFRPI=C1PWMCR_Page;C1PWMCR=(C1PWMCR&(~(C1BKE00|C1BKE01|C1BKE02)))|(C1BKE02);SFRPI=0
#define PCA1_SetBreakSource0_AC1OUT()		SFRPI=C1PWMCR_Page;C1PWMCR=(C1PWMCR&(~(C1BKE00|C1BKE01|C1BKE02)))|(C1BKE02|C1BKE00);SFRPI=0
#define PCA1_SetBreakSource0_INT3ET()		SFRPI=C1PWMCR_Page;C1PWMCR=(C1PWMCR&(~(C1BKE00|C1BKE01|C1BKE02)))|(C1BKE02|C1BKE01);SFRPI=0
#define PCA1_SetBreakSource0_ADCWI()		SFRPI=C1PWMCR_Page;C1PWMCR=(C1PWMCR&(~(C1BKE00|C1BKE01|C1BKE02)))|(C1BKE02|C1BKE01|C1BKE00);SFRPI=0

#define PCA1_SetBreakSource1_Disable()		SFRPI=C1PWMCR_Page;C1PWMCR=C1PWMCR&(~(C1BKE10|C1BKE11));SFRPI=0
#define PCA1_SetBreakSource1_INT2ET()		SFRPI=C1PWMCR_Page;C1PWMCR=(C1PWMCR&(~(C1BKE10|C1BKE11)))|(C1BKE10);SFRPI=0
#define PCA1_SetBreakSource1_T3EXI()		SFRPI=C1PWMCR_Page;C1PWMCR=(C1PWMCR&(~(C1BKE10|C1BKE11)))|(C1BKE11);SFRPI=0
#define PCA1_SetBreakSource1_OP1ES()		SFRPI=C1PWMCR_Page;C1PWMCR=(C1PWMCR&(~(C1BKE10|C1BKE11)))|(C1BKE11|C1BKE10);SFRPI=0

// PCA1 引脚设置
#define PCA1_SetC1CEX0InputPort_C1EX0()		SFRPI=AUXR8_Page;AUXR8=AUXR8&(~C1ICS0);SFRPI=0
#define PCA1_SetC1CEX0InputPort_T3EXI()		SFRPI=AUXR8_Page;AUXR8=AUXR8|(C1ICS0);SFRPI=0

#define PCA1_SetC1CEX1InputPort_C1EX1()		SFRPI=AUXR8_Page;AUXR8=AUXR8&(C1ICS1);SFRPI=0
#define PCA1_SetC1CEX1InputPort_T2EXI()		SFRPI=AUXR8_Page;AUXR8=AUXR8|(C1ICS1);SFRPI=0

#define PCA1_SetC1EX0_P60()					SFRPI=AUXR17_Page;AUXR17=AUXR17&(~C1OPS0);SFRPI=0
#define PCA1_SetC1EX0_P30()					SFRPI=AUXR17_Page;AUXR17=AUXR17|C1OPS0;SFRPI=0
#define PCA1_SetC1EX1_P61()					SFRPI=AUXR17_Page;AUXR17=AUXR17&(~C1OPS1);SFRPI=0
#define PCA1_SetC1EX1_P31()					SFRPI=AUXR17_Page;AUXR17=AUXR17|C1OPS1;SFRPI=0

#define C1EX0_P60	0
#define C1EX0_P30	BIT0
#define C1EX1_P61	0
#define C1EX1_P31	BIT1
#define	PCA1_SetC1EXn_Pin(x)				SFRPI=AUXR17_Page;AUXR17=(AUXR17&(~(C1OPS0|C1OPS1)))|x;SFRPI=0

/*
*************************************************************************************
*/

/*
//*************************************************************************************
//*  WDT
//*
//*************************************************************************************
*/
#define WDT_SetClock_32K_DIV_1_16ms()		WDTCR=(WDTCR&(~0x07))
#define WDT_SetClock_32K_DIV_2_32ms()		WDTCR=(WDTCR&(~0x07))|0x01
#define WDT_SetClock_32K_DIV_4_64ms()		WDTCR=(WDTCR&(~0x07))|0x02
#define WDT_SetClock_32K_DIV_8_128ms()		WDTCR=(WDTCR&(~0x07))|0x03
#define WDT_SetClock_32K_DIV_16_256ms()		WDTCR=(WDTCR&(~0x07))|0x04
#define WDT_SetClock_32K_DIV_32_512ms()		WDTCR=(WDTCR&(~0x07))|0x05
#define WDT_SetClock_32K_DIV_64_1024ms()	WDTCR=(WDTCR&(~0x07))|0x06
#define WDT_SetClock_32K_DIV_128_2048ms()	WDTCR=(WDTCR|(0x07))

// WDT 设置时钟来源
#define WDT_SetClock_ILRCO()			ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON3_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=IFD&(0x3F);IFADRH=0x0;IFADRL=CKCON3_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0
#define WDT_SetClock_XTAL2()			ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON3_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0x3F))|WDTCS0_P;IFADRH=0x0;IFADRL=CKCON3_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0
#define WDT_SetClock_SYSCLKDiv12()		ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON3_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0x3F))|WDTCS1_P;IFADRH=0x0;IFADRL=CKCON3_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0
#define WDT_SetClock_S0TOF()			ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON3_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0x3F))|(WDTCS1_P|WDTCS0_P);IFADRH=0x0;IFADRL=CKCON3_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0

#define WDT_EnReset()		WDTCR|=WREN
#define WDT_Enable_OnPD()	WDTCR|=NSW
#define WDT_Enable_OnIDLE()	WDTCR|=WIDL
#define WDT_Clear()			WDTCR|=CLRW
#define WDT_Enable()		WDTCR|=ENW

#define CLRWDT()	WDTCR|=CLRW
#define ENWDT()		WDTCR|=ENW
/*
*************************************************************************************
*/

/*
//*************************************************************************************
//*  RTC
//*
//*************************************************************************************
*/
#define RTC_ENABLE				BIT7
#define RTC_DISABLE				0
#define RTCKO_ENABLE			BIT6
#define RTCKO_DISABLE			0

#define RTC_SetRTCCR(x)			IFD=x;IFADRH=0x0;IFADRL=RTCCR_P;ISPCR=0x80;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0

#define RTC_CLOCK_DIV_1			15
#define RTC_CLOCK_DIV_2			14
#define RTC_CLOCK_DIV_4			13
#define RTC_CLOCK_DIV_8			12
#define RTC_CLOCK_DIV_16		11
#define RTC_CLOCK_DIV_32		10
#define RTC_CLOCK_DIV_64		9
#define RTC_CLOCK_DIV_128		8
#define RTC_CLOCK_DIV_256		7
#define RTC_CLOCK_DIV_512		6
#define RTC_CLOCK_DIV_1024		5
#define RTC_CLOCK_DIV_2048		4
#define RTC_CLOCK_DIV_4096		3
#define RTC_CLOCK_DIV_8192		2
#define RTC_CLOCK_DIV_16384		1
#define RTC_CLOCK_DIV_32768		0

#define RTCCS0_1				BIT6
#define RTCCS0_0				0
#define RTCCS1_1				BIT7
#define RTCCS1_0				0

#define RTC_SetRTCTM(x)			IFD=x;IFADRH=0x0;IFADRL=RTCTM_P;ISPCR=0x80;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0

#define RTCCS2_1				BIT0
#define RTCCS2_0				0
#define RTCCS3_1				BIT1
#define RTCCS3_0				0

#define RPSC0_1					BIT2
#define RPSC0_0					0
#define RPSC1_1					BIT3
#define RPSC1_0					0
#define RPSC2_1					BIT4
#define RPSC2_0					0
#define RCSS_XTAL2_ECKI_P60		0
#define RCSS_ILRCO				(BIT5)
#define RCSS_WDTPS				(BIT6)
#define RCSS_WDTOF				(BIT6|BIT5)
#define RCSS_SYSCLK				(BIT7)
#define RCSS_SYSCLKDiv12		(BIT7|BIT6|BIT5)

#define RTC_SetCKCON4(x)		IFD=x;IFADRH=0x0;IFADRL=CKCON4_P;ISPCR=0x80;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0



// RTC 清标志位RTCF
#define RTC_ClearRTCF()				PCON1=RTCF

// RTC 使能/禁止RTC中断
#define RTC_EnInterrupt()			SFIE=SFIE|RTCFIE
#define RTC_DisInterrupt()			SFIE=SFIE&(~RTCFIE)

/*
*************************************************************************************
*/

/*
//*************************************************************************************
//*  SID  I2C START/STOP 侦测
//*
//*************************************************************************************
*/

/*
*************************************************************************************
*/

/*
//*************************************************************************************
//*  BEEPER
//*
//*************************************************************************************
*/
// BEEPER 设置IO口
#define BEEP_SetP44_IOPort()						AUXR3=AUXR3&(~(BPOC0|BPOC1))
#define BEEP_SetP44_OutILRCODiv32_1KHz()			AUXR3=(AUXR3&(~(BPOC0|BPOC1)))|(BPOC0)
#define BEEP_SetP44_OutILRCODiv16_2KHz()			AUXR3=(AUXR3&(~(BPOC0|BPOC1)))|(BPOC1)
#define BEEP_SetP44_OutILRCODiv8_4KHz()				AUXR3=AUXR3|((BPOC0|BPOC1))

/*
*************************************************************************************
*/


/*
//*************************************************************************************
//*  KBI
//*
//*************************************************************************************
*/
// KBI 设置IO口
#define KBI_SetKBI0123_P10P11P12P13()			SFRPI=AUXR6_Page;AUXR6=AUXR6&(~(KBILPS0|KBILPS1));SFRPI=0
#define KBI_SetKBI0123_P30P31P32P33()			SFRPI=AUXR6_Page;AUXR6=(AUXR6&(~(KBILPS0|KBILPS1)))|KBILPS0;SFRPI=0
#define KBI_SetKBI0123_P01P02P05P07()			SFRPI=AUXR6_Page;AUXR6=(AUXR6&(~(KBILPS0|KBILPS1)))|KBILPS1;SFRPI=0
#define KBI_SetKBI0123_P40P41P44P45()			SFRPI=AUXR6_Page;AUXR6=AUXR6|(KBILPS1|KBILPS0);SFRPI=0

#define KBI_SetKBI4567_P14P15P16P17()			SFRPI=AUXR6_Page;AUXR6=AUXR6&(~(KBIHPS0|KBIHPS1));SFRPI=0
#define KBI_SetKBI4567_P34P35P16P17()			SFRPI=AUXR6_Page;AUXR6=(AUXR6&(~(KBIHPS0|KBIHPS1)))|KBIHPS0;SFRPI=0
#define KBI_SetKBI4567_P22P23P24P26()			SFRPI=AUXR6_Page;AUXR6=(AUXR6&(~(KBIHPS0|KBIHPS1)))|KBIHPS1;SFRPI=0
#define KBI_SetKBI4567_P60P61P16P17()			SFRPI=AUXR6_Page;AUXR6=AUXR6|(KBIHPS1|KBIHPS0);SFRPI=0

// KBI 设置比较值
#define KBI0_1	0x01
#define KBI1_1	0x02
#define KBI2_1	0x04
#define KBI3_1	0x08
#define KBI4_1	0x10
#define KBI5_1	0x20
#define KBI6_1	0x40
#define KBI7_1	0x80
#define KBI0_0	0x00
#define KBI1_0	0x00
#define KBI2_0	0x00
#define KBI3_0	0x00
#define KBI4_0	0x00
#define KBI5_0	0x00
#define KBI6_0	0x00
#define KBI7_0	0x00
#define KBI_SetKBPattern(x)					KBPATN=x

// KBI 选择使能KBI通道
#define KBI0	0x01
#define KBI1	0x02
#define KBI2	0x04
#define KBI3	0x08
#define KBI4	0x10
#define KBI5	0x20
#define KBI6	0x40
#define KBI7	0x80
#define KBI_SetKBMask(x)					KBMASK=x

// KBI 清中断标志位
#define KBI_ClrITFlag()						KBCON=KBCON&(~KBIF)

// KBI 选择侦测边沿/电平
#define KBI_SetDetectLevel()				KBCON=KBCON&(~KBES)
#define KBI_SetDetectEdge()					KBCON=KBCON|(KBES)

// KBI 选择等于比较值还不等于比较值
#define KBI_SetPatternNotEqual()			KBCON=KBCON&(~PATN_SEL)
#define KBI_SetPatternEqual()				KBCON=KBCON|(PATN_SEL)

// KBI 设置滤波
#define KBI_SetFilter_Disable()				KBCON=KBCON&(~(KBCS0|KBCS1))
#define KBI_SetFilter_Sysclk_x3()			KBCON=(KBCON&(~(KBCS0|KBCS1)))|(KBCS0)
#define KBI_SetFilter_SysclkDiv6_x3()		KBCON=(KBCON&(~(KBCS0|KBCS1)))|(KBCS1)
#define KBI_SetFilter_S0TOF_x3()			KBCON=KBCON|((KBCS0|KBCS1))
/*
*************************************************************************************
*/

/*
//*************************************************************************************
//*  DMA
//*
//*************************************************************************************
*/
// DMA 使能/禁止
#define DMA_Enable()			DMACR0=DMACR0|DMAE0
#define DMA_Disable()			DMACR0=DMACR0&(~DMAE0)

// DMA 启动/挂起
#define DMA_Start()				DMACR0=DMACR0|DMAS0
#define DMA_Suspend()			DMACR0=DMACR0&(~DMAS0)

// DMA 使能/禁止DCF0中断
#define DMA_EnDCF0Int()			DMACR0=DMACR0|DIE0
#define DMA_DisDCF0Int()		DMACR0=DMACR0&(~DIE0)

// DMA 使能/禁止copy数据到CRC16
#define DMA_EnCopy2CRC16()		SFRPI=DMACG0_Page;DMACG0=DMACG0|CRCW0;SFRPI=0
#define DMA_DisCopy2CRC16()		SFRPI=DMACG0_Page;DMACG0=DMACG0&(~CRCW0);SFRPI=0

// DMA 设置触发源
#define DMA_SetTrig_Software()		SFRPI=DMACG0_Page;DMACG0=DMACG0&(~(EXTS00|EXTS10));SFRPI=0
#define DMA_SetTrig_INT2ET()		SFRPI=DMACG0_Page;DMACG0=(DMACG0&(~(EXTS00|EXTS10)))|(EXTS00);SFRPI=0
#define DMA_SetTrig_KBIET()			SFRPI=DMACG0_Page;DMACG0=DMACG0|(EXTS00|EXTS10);SFRPI=0

// DMA 使能/禁止DMA 循环模式
#define DMA_EnLoop()				SFRPI=DMACG0_Page;DMACG0=DMACG0|LOOP0;SFRPI=0
#define DMA_DisLoop()				SFRPI=DMACG0_Page;DMACG0=DMACG0&(~LOOP0);SFRPI=0

// DMA 设置来源和目标
#define DMA_SetSource_S0RX()		SFRPI=DMADS0_Page;DMADS0=(DMADS0&(0x0F))|(DSS00);SFRPI=0
#define DMA_SetSource_S1RX()		SFRPI=DMADS0_Page;DMADS0=(DMADS0&(0x0F))|(DSS10);SFRPI=0
#define DMA_SetSource_TWI0RX()		SFRPI=DMADS0_Page;DMADS0=(DMADS0&(0x0F))|(DSS20|DSS00);SFRPI=0
#define DMA_SetSource_TWI1RX()		SFRPI=DMADS0_Page;DMADS0=(DMADS0&(0x0F))|(DSS20|DSS10);SFRPI=0
#define DMA_SetSource_SPI0RX()		SFRPI=DMADS0_Page;DMADS0=(DMADS0&(0x0F))|(DSS20|DSS10|DSS00);SFRPI=0
#define DMA_SetSource_ADC0()		SFRPI=DMADS0_Page;DMADS0=(DMADS0&(0x0F))|(DSS30|DSS00);SFRPI=0
#define DMA_SetSource_XRAM()		SFRPI=DMADS0_Page;DMADS0=DMADS0|(0xF0);SFRPI=0

#define DMA_SetDestination_S0TX()		SFRPI=DMADS0_Page;DMADS0=(DMADS0&(0xF0))|(DDS00);SFRPI=0
#define DMA_SetDestination_S1TX()		SFRPI=DMADS0_Page;DMADS0=(DMADS0&(0xF0))|(DDS10);SFRPI=0
#define DMA_SetDestination_TWI0TX()		SFRPI=DMADS0_Page;DMADS0=(DMADS0&(0xF0))|(DDS20|DDS00);SFRPI=0
#define DMA_SetDestination_TWI1TX()		SFRPI=DMADS0_Page;DMADS0=(DMADS0&(0xF0))|(DDS20|DDS10);SFRPI=0
#define DMA_SetDestination_SPI0TX()		SFRPI=DMADS0_Page;DMADS0=(DMADS0&(0xF0))|(DDS20|DDS10|DDS00);SFRPI=0
#define DMA_SetDestination_CRC()		SFRPI=DMADS0_Page;DMADS0=(DMADS0&(0xF0))|(DDS30|DDS20|DDS00);SFRPI=0
#define DMA_SetDestination_XRAM()		SFRPI=DMADS0_Page;DMADS0=DMADS0|(0x0F);SFRPI=0

// DMA 设置DMA XRAM起始地址
#define DMA_SetXRAMStartaddr(x)		SFRPI=TL6_Page;TL6=(x)&0xFF;TH6=(x)>>8;SFRPI=0
// DMA 设置DMA XRAM起始地址重载值
#define DMA_SetXRAMStartaddrRL(x)	SFRPI=TLR6_Page;TLR6=(x)&0xFF;THR6=(x)>>8;SFRPI=0

// DMA 设置DMA 计数
#define DMA_SetCount(x)				SFRPI=TL5_Page;TL5=(x)&0xFF;TH5=(x)>>8;SFRPI=0
// DMA 设置DMA 计数重载值
#define DMA_SetCountRL(x)			SFRPI=TLR5_Page;TLR5=(x)&0xFF;THR5=(x)>>8;SFRPI=0

// DMA 清/检测DMA完成标志
#define DMA_ClearCompleteFlag()		DMACR0=DMACR0&(~DCF0)
#define DMA_ChkCompleteFlag()		(DMACR0&DCF0)

/*
*************************************************************************************
*/

/*
//*************************************************************************************
//*  GPL 通用逻辑
//*
//*************************************************************************************
*/
// GPL 位序更改
#define GPL_BOREV(x)								BOREV=x;x=BOREV

// GPL CRC操作
#define GPL_CRC_CRC0DA_WriteDataIn()				SFRPI=AUXR12_Page;AUXR12=AUXR12&(~CRCDS2);SFRPI=0;AUXR1=AUXR1|(CRCDS0|CRCDS1)
#define GPL_CRC_CRC0DA_Write(x)						CRC0DA=x

#define GPL_CRC_CRC0DA_WriteCRC16SeedL()			SFRPI=AUXR12_Page;AUXR12=AUXR12&(~CRCDS2);SFRPI=0;AUXR1=AUXR1&(~(CRCDS0|CRCDS1))
#define GPL_CRC_CRC0DA_WriteCRC16SeedH()			SFRPI=AUXR12_Page;AUXR12=AUXR12&(~CRCDS2);SFRPI=0;AUXR1=(AUXR1&(~(CRCDS0|CRCDS1)))|(CRCDS0)
#define GPL_CRC_CRC0DA_ReadCRC16ResultL()			SFRPI=AUXR12_Page;AUXR12=AUXR12&(~CRCDS2);SFRPI=0;AUXR1=AUXR1&(~(CRCDS0|CRCDS1))
#define GPL_CRC_CRC0DA_ReadCRC16ResultH()			SFRPI=AUXR12_Page;AUXR12=AUXR12&(~CRCDS2);SFRPI=0;AUXR1=(AUXR1&(~(CRCDS0|CRCDS1)))|(CRCDS0)

#define GPL_CRC_CRC0DA_WriteCRC32Seed0()			SFRPI=AUXR12_Page;AUXR12=AUXR12&(~CRCDS2);SFRPI=0;AUXR1=AUXR1&(~(CRCDS0|CRCDS1))
#define GPL_CRC_CRC0DA_WriteCRC32Seed1()			SFRPI=AUXR12_Page;AUXR12=AUXR12&(~CRCDS2);SFRPI=0;AUXR1=(AUXR1&(~(CRCDS0|CRCDS1)))|(CRCDS0)
#define GPL_CRC_CRC0DA_WriteCRC32Seed2()			SFRPI=AUXR12_Page;AUXR12=AUXR12|(CRCDS2);SFRPI=0;AUXR1=AUXR1&(~(CRCDS0|CRCDS1))
#define GPL_CRC_CRC0DA_WriteCRC32Seed3()			SFRPI=AUXR12_Page;AUXR12=AUXR12|(CRCDS2);SFRPI=0;AUXR1=(AUXR1&(~(CRCDS0|CRCDS1)))|(CRCDS0)
#define GPL_CRC_CRC0DA_ReadCRC32Result0()			SFRPI=AUXR12_Page;AUXR12=AUXR12&(~CRCDS2);SFRPI=0;AUXR1=AUXR1&(~(CRCDS0|CRCDS1))
#define GPL_CRC_CRC0DA_ReadCRC32Result1()			SFRPI=AUXR12_Page;AUXR12=AUXR12&(~CRCDS2);SFRPI=0;AUXR1=(AUXR1&(~(CRCDS0|CRCDS1)))|(CRCDS0)
#define GPL_CRC_CRC0DA_ReadCRC32Result2()			SFRPI=AUXR12_Page;AUXR12=AUXR12&(~CRCDS2);SFRPI=0;AUXR1=(AUXR1&(~(CRCDS0|CRCDS1)))|(CRCDS1)
#define GPL_CRC_CRC0DA_ReadCRC32Result3()			SFRPI=AUXR12_Page;AUXR12=AUXR12&(~CRCDS2);SFRPI=0;AUXR1=AUXR1|(CRCDS0|CRCDS1)


#define GPL_CRC_WriteCRCData(x)						SFRPI=AUXR12_Page;AUXR12=AUXR12&(~CRCDS2);SFRPI=0;AUXR1=AUXR1|(CRCDS0|CRCDS1);CRC0DA=x

#define GPL_CRC_WriteCRCSeedL(x)					SFRPI=AUXR12_Page;AUXR12=AUXR12&(~CRCDS2);SFRPI=0;AUXR1=AUXR1&(~(CRCDS0|CRCDS1));CRC0DA=x
#define GPL_CRC_WriteCRCSeedH(x)					SFRPI=AUXR12_Page;AUXR12=AUXR12&(~CRCDS2);SFRPI=0;AUXR1=(AUXR1&(~(CRCDS0|CRCDS1)))|(CRCDS0);CRC0DA=x
#define GPL_CRC_ReadCRCResultL(x)					SFRPI=AUXR12_Page;AUXR12=AUXR12&(~CRCDS2);SFRPI=0;AUXR1=AUXR1&(~(CRCDS0|CRCDS1));x=CRC0DA
#define GPL_CRC_ReadCRCResultH(x)					SFRPI=AUXR12_Page;AUXR12=AUXR12&(~CRCDS2);SFRPI=0;AUXR1=(AUXR1&(~(CRCDS0|CRCDS1)))|(CRCDS0);x=CRC0DA

#define GPL_CRC_WriteCRC32Seed0(x)					SFRPI=AUXR12_Page;AUXR12=AUXR12&(~CRCDS2);SFRPI=0;AUXR1=AUXR1&(~(CRCDS0|CRCDS1));CRC0DA=x
#define GPL_CRC_WriteCRC32Seed1(x)					SFRPI=AUXR12_Page;AUXR12=AUXR12&(~CRCDS2);SFRPI=0;AUXR1=(AUXR1&(~(CRCDS0|CRCDS1)))|(CRCDS0);CRC0DA=x
#define GPL_CRC_WriteCRC32Seed2(x)					SFRPI=AUXR12_Page;AUXR12=AUXR12|(CRCDS2);SFRPI=0;AUXR1=AUXR1&(~(CRCDS0|CRCDS1));CRC0DA=x
#define GPL_CRC_WriteCRC32Seed3(x)					SFRPI=AUXR12_Page;AUXR12=AUXR12|(CRCDS2);SFRPI=0;AUXR1=(AUXR1&(~(CRCDS0|CRCDS1)))|(CRCDS0);CRC0DA=x
#define GPL_CRC_ReadCRC32Result0(x)					SFRPI=AUXR12_Page;AUXR12=AUXR12&(~CRCDS2);SFRPI=0;AUXR1=AUXR1&(~(CRCDS0|CRCDS1));x=CRC0DA
#define GPL_CRC_ReadCRC32Result1(x)					SFRPI=AUXR12_Page;AUXR12=AUXR12&(~CRCDS2);SFRPI=0;AUXR1=(AUXR1&(~(CRCDS0|CRCDS1)))|(CRCDS0);x=CRC0DA
#define GPL_CRC_ReadCRC32Result2(x)					SFRPI=AUXR12_Page;AUXR12=AUXR12&(~CRCDS2);SFRPI=0;AUXR1=(AUXR1&(~(CRCDS0|CRCDS1)))|(CRCDS1);x=CRC0DA
#define GPL_CRC_ReadCRC32Result3(x)					SFRPI=AUXR12_Page;AUXR12=AUXR12&(~CRCDS2);SFRPI=0;AUXR1=AUXR1|(CRCDS0|CRCDS1);x=CRC0DA

#define GPL_CRCMode_CRC16_0x1021()					SFRPI=AUXR12_Page;AUXR12=AUXR12&(~CRCM0);SFRPI=0
#define GPL_CRCMode_CRC32_0x04C1_1DB7()				SFRPI=AUXR12_Page;AUXR12=AUXR12|(CRCM0);SFRPI=0

// GPL 设置SFR 0xA9地址是访问SADDR还是EDC45
#define GPL_SetAccess0xA9_SADDR()					SFRPI=AUXR12_Page;AUXR12=AUXR12&(~GPLC0);SFRPI=0
#define GPL_SetAccess0xA9_EDC45()					SFRPI=AUXR12_Page;AUXR12=AUXR12|(GPLC0);SFRPI=0


/*
*************************************************************************************
*/

/*
//*************************************************************************************
//*  POWER 电源控制
//*
//*************************************************************************************
*/
#define POW_BOD1_Enable_OnPD		BIT7
#define POW_BOD1_Disable_OnPD		0x00

#define POW_BOD1_Set20V				0x00
#define POW_BOD1_Set24V				B00010000
#define POW_BOD1_Set36V				B00100000
#define POW_BOD1_Set42V				B00110000

#define POW_BOD1_Enable				BIT2
#define POW_BOD1_Disable			0x00

#define POW_BOD1_EnReset			BIT3
#define POW_BOD1_DisReset			0x00

#define POW_BOD0_EnReset			BIT1
#define POW_BOD0_DisReset			0x00

#define POW_SetMode_PD()			PCON0|=PD;

#define POW_ResetToAP()				ISPCR=SRST
#define POW_ResetToISP()			ISPCR=SWBS|SRST

/*
*************************************************************************************
*/


/*
//*************************************************************************************
//*  AC0
//*
//*************************************************************************************
*/
// AC0 设置低功耗模式
#define AC0_DisLowPower()							AC0CON=AC0CON&(~(AC0LP))
#define AC0_EnLowPower()							AC0CON=AC0CON|AC0LP

// AC0 设置掉电模式继续运行
#define AC0_DisPDRunning()							AC0CON=AC0CON&(~(AC0PDX))
#define AC0_EnPDRunning()							AC0CON=AC0CON|AC0PDX

// AC0 设置使能
#define AC0_Disable()								AC0CON=AC0CON&(~(AC0EN))
#define AC0_Enable()								AC0CON=AC0CON|AC0EN

// AC0 设置输出反相
#define AC0_SetOutput_DisInvert()					AC0CON=AC0CON&(~(AC0INV))
#define AC0_SetOutput_EnInvert()					AC0CON=AC0CON|AC0INV

// AC0 设置中断模式
#define AC0_SetInterruptMode_Falling()				AC0CON=AC0CON&(~(AC0M0|AC0M1))|(AC0M0)
#define AC0_SetInterruptMode_Rising()				AC0CON=AC0CON&(~(AC0M0|AC0M1))|(AC0M1)
#define AC0_SetInterruptMode_Togging()				AC0CON=AC0CON|(AC0M0|AC0M1)

// AC0 设置负极参考电压输入
#define AC0_SetNegaReferenceVoltage_IntVref()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRL)
#define AC0_SetNegaReferenceVoltage_1_24_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS0|NVRL)
#define AC0_SetNegaReferenceVoltage_2_24_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS1|NVRL)
#define AC0_SetNegaReferenceVoltage_3_24_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS0|NVRS1|NVRL)
#define AC0_SetNegaReferenceVoltage_4_24_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS2|NVRL)
#define AC0_SetNegaReferenceVoltage_5_24_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS2|NVRS0|NVRL)
#define AC0_SetNegaReferenceVoltage_6_24_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS2|NVRS1|NVRL)
#define AC0_SetNegaReferenceVoltage_7_24_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS2|NVRS1|NVRS0|NVRL)
#define AC0_SetNegaReferenceVoltage_8_24_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS3|NVRL)
#define AC0_SetNegaReferenceVoltage_9_24_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS3|NVRS0|NVRL)
#define AC0_SetNegaReferenceVoltage_10_24_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS3|NVRS1|NVRL)
#define AC0_SetNegaReferenceVoltage_11_24_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS3|NVRS1|NVRS0|NVRL)
#define AC0_SetNegaReferenceVoltage_12_24_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS3|NVRS2|NVRL)
#define AC0_SetNegaReferenceVoltage_13_24_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS3|NVRS2|NVRS0|NVRL)
#define AC0_SetNegaReferenceVoltage_14_24_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS3|NVRS2|NVRS1|NVRL)

#define AC0_SetNegaReferenceVoltage_AC0NI_P34()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))
#define AC0_SetNegaReferenceVoltage_9_32_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS0)
#define AC0_SetNegaReferenceVoltage_10_32_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS1)
#define AC0_SetNegaReferenceVoltage_11_32_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS0|NVRS1)
#define AC0_SetNegaReferenceVoltage_12_32_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS2)
#define AC0_SetNegaReferenceVoltage_13_32_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS2|NVRS0)
#define AC0_SetNegaReferenceVoltage_14_32_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS2|NVRS1)
#define AC0_SetNegaReferenceVoltage_15_32_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS2|NVRS1|NVRS0)
#define AC0_SetNegaReferenceVoltage_16_32_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS3)
#define AC0_SetNegaReferenceVoltage_17_32_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS3|NVRS0)
#define AC0_SetNegaReferenceVoltage_18_32_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS3|NVRS1)
#define AC0_SetNegaReferenceVoltage_19_32_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS3|NVRS1|NVRS0)
#define AC0_SetNegaReferenceVoltage_20_32_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS3|NVRS2)
#define AC0_SetNegaReferenceVoltage_21_32_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS3|NVRS2|NVRS0)
#define AC0_SetNegaReferenceVoltage_22_32_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS3|NVRS2|NVRS1)
#define AC0_SetNegaReferenceVoltage_OP1O()			AC0MOD=(AC0MOD&(~(NVRL)))|(NVRS3|NVRS2|NVRS1|NVRS0)

// AC0 设置输出滤波
#define AC0_SetFilter_Disable()						SFRPI=AC0CR1_Page;AC0CR1=AC0CR1&(~(AC0FLT0|AC0FLT1));SFRPI=0
#define AC0_SetFilter_Sysclk_x3()					SFRPI=AC0CR1_Page;AC0CR1=AC0CR1&(~(AC0FLT0|AC0FLT1))|(AC0FLT0);SFRPI=0
#define AC0_SetFilter_SysclkDiv6_x3()				SFRPI=AC0CR1_Page;AC0CR1=AC0CR1&(~(AC0FLT0|AC0FLT1))|(AC0FLT1);SFRPI=0
#define AC0_SetFilter_T3OF_x3()						SFRPI=AC0CR1_Page;AC0CR1=AC0CR1|(AC0FLT0|AC0FLT1);SFRPI=0

// AC0  Offset voltage trim
#define AC0_SetMode_Normal()						SFRPI=AC0CR1_Page;AC0CR1=AC0CR1&(~(AC0TR));SFRPI=0
#define AC0_SetMOde_OffsetVoltageTrim()				SFRPI=AC0CR1_Page;AC0CR1=AC0CR1|AC0TR;SFRPI=0

// AC0 设置正极输入引脚
#define AC0_SetPosInput_AC0PI0_P35()				AC0MOD=AC0MOD&(~(AC0PIS0|AC0PIS1))
#define AC0_SetPosInput_AC0PI1_OP0O()				AC0MOD=AC0MOD&(~(AC0PIS0|AC0PIS1))|(AC0PIS0)
#define AC0_SetPosInput_AC0PI2_P40()				AC0MOD=AC0MOD&(~(AC0PIS0|AC0PIS1))|(AC0PIS1)
#define AC0_SetPosInput_AC0PI3_PGDO()				AC0MOD=AC0MOD|(AC0PIS0|AC0PIS1)

// AC0 设置迟滞控制
#define AC0_SetHysteresis_00mV()					SFRPI=AC0CR1_Page;AC0CR1=AC0CR1&(~(AC0HC0|AC0HC1));SFRPI=0
#define AC0_SetHysteresis_10mV()					SFRPI=AC0CR1_Page;AC0CR1=(AC0CR1&(~(AC0HC0|AC0HC1)))|(AC0HC0);SFRPI=0
#define AC0_SetHysteresis_20mV()					SFRPI=AC0CR1_Page;AC0CR1=(AC0CR1&(~(AC0HC0|AC0HC1)))|(AC0HC1);SFRPI=0
#define AC0_SetHysteresis_60mV()					SFRPI=AC0CR1_Page;AC0CR1=AC0CR1|(AC0HC0|AC0HC1);SFRPI=0

// AC0 设置AC0OUT输出
#define AC0_SetAC0OUT_Disable()						SFRPI=AUXR4_Page;AUXR4=AUXR4&(~(AC0OE));SFRPI=0
#define AC0_SetAC0OUT_P45()							SFRPI=AUXR4_Page;AUXR4=AUXR4|AC0OE;SFRPI=0

/*
*************************************************************************************
*/

/*
//*************************************************************************************
//*  AC1
//*
//*************************************************************************************
*/
// AC1 设置低功耗模式
#define AC1_DisLowPower()							SFRPI=AC1CON_Page;AC1CON=AC1CON&(~(AC1LP));SFRPI=0
#define AC1_EnLowPower()							SFRPI=AC1CON_Page;AC1CON=AC1CON|AC1LP;SFRPI=0

// AC1 设置掉电模式继续运行
#define AC1_DisPDRunning()							SFRPI=AC1CON_Page;AC1CON=AC1CON&(~(AC1PDX));SFRPI=0
#define AC1_EnPDRunning()							SFRPI=AC1CON_Page;AC1CON=AC1CON|AC1PDX;SFRPI=0

// AC1 设置使能
#define AC1_Disable()								SFRPI=AC1CON_Page;AC1CON=AC1CON&(~(AC1EN));SFRPI=0
#define AC1_Enable()								SFRPI=AC1CON_Page;AC1CON=AC1CON|AC1EN;SFRPI=0

// AC1 设置输出反相
#define AC1_SetOutput_DisInvert()					SFRPI=AC1CON_Page;AC1CON=AC1CON&(~(AC1INV));SFRPI=0
#define AC1_SetOutput_EnInvert()					SFRPI=AC1CON_Page;AC1CON=AC1CON|AC1INV;SFRPI=0

// AC1 设置中断模式
#define AC1_SetInterruptMode_Falling()				SFRPI=AC1CON_Page;AC1CON=AC1CON&(~(AC1M0|AC1M1))|(AC1M0);SFRPI=0
#define AC1_SetInterruptMode_Rising()				SFRPI=AC1CON_Page;AC1CON=AC1CON&(~(AC1M0|AC1M1))|(AC1M1);SFRPI=0
#define AC1_SetInterruptMode_Togging()				SFRPI=AC1CON_Page;AC1CON=AC1CON|(AC1M0|AC1M1);SFRPI=0

// AC1 设置负极参考电压输入
#define AC1_SetNegaInput_AC1NI_P02()				SFRPI=AC1MOD_Page;AC1MOD=AC1MOD&(~(AC1NIS|NVRL1));SFRPI=0
#define AC1_SetNegaReferenceVoltage_IntVref()		SFRPI=AC1MOD_Page;AC1MOD=AC1MOD&(~(AC1NIS|NVRL1))|(NVRL1);SFRPI=0
#define AC1_SetNegaInput_ACNI0()					SFRPI=AC1MOD_Page;AC1MOD=AC1MOD&(~(AC1NIS|NVRL1))|(AC1NIS);SFRPI=0

// AC1 设置输出滤波
#define AC1_SetFilter_Disable()						SFRPI=AC1MOD_Page;AC1MOD=AC1MOD&(~(AC1FLT0|AC1FLT1));SFRPI=0
#define AC1_SetFilter_Sysclk_x3()					SFRPI=AC1MOD_Page;AC1MOD=AC1MOD&(~(AC1FLT0|AC1FLT1))|(AC1FLT0);SFRPI=0
#define AC1_SetFilter_SysclkDiv6_x3()				SFRPI=AC1MOD_Page;AC1MOD=AC1MOD&(~(AC1FLT0|AC1FLT1))|(AC1FLT1);SFRPI=0
#define AC1_SetFilter_T3OF_x3()						SFRPI=AC1MOD_Page;AC1MOD=AC1MOD|(AC1FLT0|AC1FLT1);SFRPI=0

// AC1 设置迟滞控制
#define AC1_SetHysteresis_00mV()					SFRPI=AC1MOD_Page;AC1MOD=AC1MOD&(~(AC1HC0|AC1HC1));SFRPI=0
#define AC1_SetHysteresis_10mV()					SFRPI=AC1MOD_Page;AC1MOD=(AC1MOD&(~(AC1HC0|AC1HC1)))|(AC1HC0);SFRPI=0
#define AC1_SetHysteresis_20mV()					SFRPI=AC1MOD_Page;AC1MOD=(AC1MOD&(~(AC1HC0|AC1HC1)))|(AC1HC1);SFRPI=0
#define AC1_SetHysteresis_60mV()					SFRPI=AC1MOD_Page;AC1MOD=AC1MOD|(AC1HC0|AC1HC1);SFRPI=0

// AC1  Offset voltage trim
#define AC1_SetMode_Normal()						SFRPI=AC1MOD_Page;AC1MOD=AC1MOD&(~(AC1TR));SFRPI=0
#define AC1_SetMOde_OffsetVoltageTrim()				SFRPI=AC1MOD_Page;AC1MOD=AC1MOD|AC1TR;SFRPI=0

// AC1 设置AC1OUT输出
#define AC1_SetAC1OUT_Disable()						SFRPI=AUXR4_Page;AUXR4=AUXR4&(~(AC1OE));SFRPI=0
#define AC1_SetAC1OUT_P05()							SFRPI=AUXR4_Page;AUXR4=AUXR4|AC1OE;SFRPI=0

/*
*************************************************************************************
*/

/*
//*************************************************************************************
//*  OPA
//*
//*************************************************************************************
*/
// OPA 模式选择
#define OPA0_SetMode_OPA()							SFRPI=OPCMP_Page;OPCMP=OPCMP&(~(OP0M1|OP0M0|BIT7|BIT6));SFRPI=0
#define OPA0_SetMode_CMP_FallingEdge()				SFRPI=OPCMP_Page;OPCMP=(OPCMP&(~(OP0M1|OP0M0|BIT7|BIT6)))|OP0M0;SFRPI=0
#define OPA0_SetMode_CMP_RisingEdge()				SFRPI=OPCMP_Page;OPCMP=(OPCMP&(~(OP0M1|OP0M0|BIT7|BIT6)))|OP0M1;SFRPI=0
#define OPA0_SetMode_CMP_DualEdge()					SFRPI=OPCMP_Page;OPCMP=OPCMP|(OP0M1|OP0M0|BIT7|BIT6);SFRPI=0

#define OPA1_SetMode_OPA()							SFRPI=OPCMP_Page;OPCMP=OPCMP&(~(OP1M1|OP1M0|BIT7|BIT6));SFRPI=0
#define OPA1_SetMode_CMP_FallingEdge()				SFRPI=OPCMP_Page;OPCMP=(OPCMP&(~(OP1M1|OP1M0|BIT7|BIT6)))|OP1M0;SFRPI=0
#define OPA1_SetMode_CMP_RisingEdge()				SFRPI=OPCMP_Page;OPCMP=(OPCMP&(~(OP1M1|OP1M0|BIT7|BIT6)))|OP1M1;SFRPI=0
#define OPA1_SetMode_CMP_DualEdge()					SFRPI=OPCMP_Page;OPCMP=OPCMP|(OP1M1|OP1M0|BIT7|BIT6);SFRPI=0

// OPA 设置使能
#define OPA0_Disable()								SFRPI=OP0CON0_Page;OP0CON0=OP0CON0&(~(OP0EN));SFRPI=0
#define OPA0_Enable()								SFRPI=OP0CON0_Page;OP0CON0=OP0CON0|OP0EN;SFRPI=0

#define OPA1_Disable()								SFRPI=OP1CON0_Page;OP1CON0=OP1CON0&(~(OP1EN));SFRPI=0
#define OPA1_Enable()								SFRPI=OP1CON0_Page;OP1CON0=OP1CON0|OP1EN;SFRPI=0

// OPA 设置掉电模式下使能
#define OPA0_OnPD_Disable()							SFRPI=OPCMP_Page;OPCMP=OPCMP&(~(OP0PDX));SFRPI=0
#define OPA0_OnPD_Enable()							SFRPI=OPCMP_Page;OPCMP=OPCMP|OP0PDX;SFRPI=0

#define OPA1_OnPD_Disable()							SFRPI=OPCMP_Page;OPCMP=OPCMP&(~(OP1PDX));SFRPI=0
#define OPA1_OnPD_Enable()							SFRPI=OPCMP_Page;OPCMP=OPCMP|OP1PDX;SFRPI=0

// OPA 功耗模式
#define OPA0_OPA1_PowerLevel_High()					SFRPI=OP0CON0_Page;OP0CON0=OP0CON0&(~(OPPWR));SFRPI=0
#define OPA0_OPA1_PowerLevel_Low()					SFRPI=OP0CON0_Page;OP0CON0=OP0CON0|OPPWR;SFRPI=0

#define OPA0_LowPower_Disable()						SFRPI=OP0CON0_Page;OP0CON0=OP0CON0&(~(OP0LP));SFRPI=0
#define OPA0_LowPower_Enable()						SFRPI=OP0CON0_Page;OP0CON0=OP0CON0|OP0LP;SFRPI=0

#define OPA1_LowPower_Disable()						SFRPI=OP1CON0_Page;OP1CON0=OP1CON0&(~(OP1LP));SFRPI=0
#define OPA1_LowPower_Enable()						SFRPI=OP1CON0_Page;OP1CON0=OP1CON0|OP1LP;SFRPI=0

// OPA 忽略中断
#define OPA0_InterruptIgnore_Disable()				SFRPI=OP0CON0_Page;OP0CON0=OP0CON0&(~(OP0IG));SFRPI=0
#define OPA0_InterruptIgnore_Enable()				SFRPI=OP0CON0_Page;OP0CON0=OP0CON0|OP0IG;SFRPI=0

#define OPA1_InterruptIgnore_Disable()				SFRPI=OP1CON0_Page;OP1CON0=OP1CON0&(~(OP1IG));SFRPI=0
#define OPA1_InterruptIgnore_Enable()				SFRPI=OP1CON0_Page;OP1CON0=OP1CON0|OP1IG;SFRPI=0

// OPA +端输入
#define OPA0_SetPositiveInput_IVR12()				SFRPI=OP0CON0_Page;OP0CON0=OP0CON0&(~(OP0PIS0|OP0PIS1));SFRPI=0
#define OPA0_SetPositiveInput_OP0PI_P17()			SFRPI=OP0CON0_Page;OP0CON0=(OP0CON0&(~(OP0PIS0|OP0PIS1)))|OP0PIS0;SFRPI=0
#define OPA0_SetPositiveInput_PGADO()				SFRPI=OP0CON0_Page;OP0CON0=OP0CON0|OP0PIS1;SFRPI=0

#define OPA1_SetPositiveInput_IVR12()				SFRPI=OP1CON0_Page;OP0CON0=OP0CON0&(~(OP1PIS0|OP1PIS1));SFRPI=0
#define OPA1_SetPositiveInput_OP1PI_P24()			SFRPI=OP1CON0_Page;OP0CON0=(OP0CON0&(~(OP1PIS0|OP1PIS1)))|OP1PIS0;SFRPI=0
#define OPA1_SetPositiveInput_PGADO()				SFRPI=OP1CON0_Page;OP0CON0=OP0CON0|OP1PIS1;SFRPI=0

// OPA -端输入
#define OPA0_SetNegativeInput_IVR12()				SFRPI=OP0CON0_Page;OP0CON0=OP0CON0&(~(OP0NIS0|OP0NIS1));SFRPI=0
#define OPA0_SetNegativeInput_OP0NI_P22()			SFRPI=OP0CON0_Page;OP0CON0=(OP0CON0&(~(OP0NIS0|OP0NIS1)))|OP0NIS0;SFRPI=0
#define OPA0_SetNegativeInput_OP0O()				SFRPI=OP0CON0_Page;OP0CON0=OP0CON0|OP0NIS1;SFRPI=0

#define OPA1_SetNegativeInput_IVR12()				SFRPI=OP1CON0_Page;OP0CON0=OP0CON0&(~(OP1NIS0|OP1NIS1));SFRPI=0
#define OPA1_SetNegativeInput_OP1NI_P26()			SFRPI=OP1CON0_Page;OP0CON0=(OP0CON0&(~(OP1NIS0|OP1NIS1)))|OP1NIS0;SFRPI=0
#define OPA1_SetNegativeInput_OP1O()				SFRPI=OP1CON0_Page;OP0CON0=OP0CON0|OP1NIS1;SFRPI=0

// OPA 设置Offset
#define OPA0_ReadOffset(x)							IFADRH=0x0;IFADRL=OP0CFG0_P;ISPCR=0x80;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();x=IFD;ISPCR=0x0;IFMT=0
#define OPA0_WriteOffset(x)							IFD=x;IFADRH=0x0;IFADRL=OP0CFG0_P;ISPCR=0x80;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();ISPCR=0x0;IFMT=0

#define OPA1_ReadOffset(x)							IFADRH=0x0;IFADRL=OP1CFG0_P;ISPCR=0x80;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();x=IFD;ISPCR=0x0;IFMT=0
#define OPA1_WriteOffset(x)							IFD=x;IFADRH=0x0;IFADRL=OP1CFG0_P;ISPCR=0x80;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();ISPCR=0x0;IFMT=0

/*
*************************************************************************************
*/

/*
//*************************************************************************************
//*  PGA
//*
//*************************************************************************************
*/
// PGA 设置使能
#define PGA_Disable()								SFRPI=PGACON0_Page;PGACON0=PGACON0&(~(PGEN));SFRPI=0
#define PGA_Enable()								SFRPI=PGACON0_Page;PGACON0=PGACON0|PGEN;SFRPI=0


// PGA 功耗模式
#define PGA_LowPower_Disable()						SFRPI=PGACON0_Page;PGACON0=PGACON0&(~(PGLP));SFRPI=0
#define PGA_LowPower_Enable()						SFRPI=PGACON0_Page;PGACON0=PGACON0|PGLP;SFRPI=0

// PGA 输出选择
#define PGA_Output_DisconnectIO()					SFRPI=PGACON0_Page;PGACON0=PGACON0&(~(PGAOE));SFRPI=0
#define PGA_Output_PGOPin()							SFRPI=PGACON0_Page;PGACON0=PGACON0|PGAOE;SFRPI=0

// PGA +端输入
#define PGA_SetPositiveInput_IVR12()				SFRPI=PGACON0_Page;PGACON0=PGACON0&(~(PGPIS1|PGPIS0));SFRPI=0
#define PGA_SetPositiveInput_AGND()					SFRPI=PGACON0_Page;PGACON0=(PGACON0&(~(PGPIS1|PGPIS0)))|PGPIS0;SFRPI=0
#define PGA_SetPositiveInput_AIN()					SFRPI=PGACON0_Page;PGACON0=(PGACON0&(~(PGPIS1|PGPIS0)))|PGPIS1;SFRPI=0
#define PGA_SetPositiveInput_PGPI_P10()				SFRPI=PGACON0_Page;PGACON0=PGACON0|(PGPIS1|PGPIS0);SFRPI=0

// PGA 倍率选择
#define PGA_SetFirstStageGain_X1()					SFRPI=PGACON1_Page;PGACON1=PGACON1&(~PGENS1GN);SFRPI=0
#define PGA_SetFirstStageGain_X8()					SFRPI=PGACON1_Page;PGACON1=PGACON1|PGENS1GN;SFRPI=0

#define PGA_SetFirstStage_Bypass()					SFRPI=PGACON1_Page;PGACON1=PGACON1&(~PGGNM);SFRPI=0
#define PGA_SetFirstStage_Enable()					SFRPI=PGACON1_Page;PGACON1=PGACON1|(PGGNM);SFRPI=0

#define PGA_SetSecondStageGain_X1()					SFRPI=PGACON1_Page;PGACON1=PGACON1&(~(PGGN2|PGGN1|PGGN0));SFRPI=0
#define PGA_SetSecondStageGain_X2()					SFRPI=PGACON1_Page;PGACON1=(PGACON1&(~(PGGN2|PGGN1|PGGN0)))|(PGGN0);SFRPI=0
#define PGA_SetSecondStageGain_X4()					SFRPI=PGACON1_Page;PGACON1=(PGACON1&(~(PGGN2|PGGN1|PGGN0)))|(PGGN1);SFRPI=0
#define PGA_SetSecondStageGain_X8()					SFRPI=PGACON1_Page;PGACON1=(PGACON1&(~(PGGN2|PGGN1|PGGN0)))|(PGGN1|PGGN0);SFRPI=0
#define PGA_SetSecondStageGain_X16()				SFRPI=PGACON1_Page;PGACON1=(PGACON1&(~(PGGN2|PGGN1|PGGN0)))|(PGGN2);SFRPI=0

// PGA 设置Offset
#define PGA_ReadOffset(x)							IFADRH=0x0;IFADRL=PGACFG0_P;ISPCR=0x80;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();x=IFD;ISPCR=0x0;IFMT=0
#define PGA_WriteOffset(x)							IFD=x;IFADRH=0x0;IFADRL=PGACFG0_P;ISPCR=0x80;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();ISPCR=0x0;IFMT=0

// PGA 实际偏移值地址
#define	PGA_FirstStageOffsetValue_Addr				0x0030
#define	PGA_SecondStageOffsetValue_Addr				0x0031

// PGA 实际Gain值地址
#define	PGA_FirstStageGainX1Value_Addr				0x0032
#define	PGA_FirstStageGainX1Value_AddrH				0x0032
#define	PGA_FirstStageGainX1Value_AddrL				0x0033
#define	PGA_FirstStageGainX8Value_Addr				0x0034
#define	PGA_FirstStageGainX8Value_AddrH				0x0034
#define	PGA_FirstStageGainX8Value_AddrL				0x0035
#define	PGA_SecondStageGainX1Value_Addr				0x0036
#define	PGA_SecondStageGainX1Value_AddrH			0x0036
#define	PGA_SecondStageGainX1Value_AddrL			0x0037
#define	PGA_SecondStageGainX2Value_Addr				0x0038
#define	PGA_SecondStageGainX2Value_AddrH			0x0038
#define	PGA_SecondStageGainX2Value_AddrL			0x0039
#define	PGA_SecondStageGainX4Value_Addr				0x003A
#define	PGA_SecondStageGainX4Value_AddrH			0x003A
#define	PGA_SecondStageGainX4Value_AddrL			0x003B
#define	PGA_SecondStageGainX8Value_Addr				0x003C
#define	PGA_SecondStageGainX8Value_AddrH			0x003C
#define	PGA_SecondStageGainX8Value_AddrL			0x003D
#define	PGA_SecondStageGainX16Value_Addr			0x003E
#define	PGA_SecondStageGainX16Value_AddrH			0x003E
#define	PGA_SecondStageGainX16Value_AddrL			0x003F


/*
*************************************************************************************
*/

#endif



